/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExponentialLogistic;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class ExponentialLogisticModel
extends DemographicModel
implements Citable {
    Parameter N0Parameter = null;
    Parameter logisticGrowthParameter = null;
    Parameter logisticShapeParameter = null;
    Parameter exponentialGrowthParameter = null;
    Parameter transistionTimeParameter = null;
    double alpha = 0.5;
    ExponentialLogistic exponentialLogistic = null;
    public static Citation CITATION = new Citation(new Author[]{new Author("OG", "Pybus"), new Author("A", "Rambaut")}, "GENIE: estimating demographic history from molecular phylogenies", 2001, "Bioinformatics", 18, 1404, 1405);

    public ExponentialLogisticModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, double d, Units.Type type) {
        this("exponentialLogistic", parameter, parameter2, parameter3, parameter4, parameter5, d, type);
    }

    public ExponentialLogisticModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Parameter parameter5, double d, Units.Type type) {
        super(string);
        this.exponentialLogistic = new ExponentialLogistic(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.logisticGrowthParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.logisticShapeParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.exponentialGrowthParameter = parameter4;
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.transistionTimeParameter = parameter5;
        this.addVariable(parameter5);
        parameter5.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.alpha = d;
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.exponentialLogistic.setN0(this.N0Parameter.getParameterValue(0));
        double d = this.logisticGrowthParameter.getParameterValue(0);
        this.exponentialLogistic.setGrowthRate(d);
        double d2 = this.exponentialGrowthParameter.getParameterValue(0);
        this.exponentialLogistic.setR1(d2);
        double d3 = this.transistionTimeParameter.getParameterValue(0) - this.getTimeOffset();
        this.exponentialLogistic.setTime(d3);
        this.exponentialLogistic.setTime50(this.logisticShapeParameter.getParameterValue(0) - this.getTimeOffset());
        return this.exponentialLogistic;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Exponential-Logistic Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

