% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countryHarmoniseR.R
\name{countryHarmoniseR}
\alias{countryHarmoniseR}
\title{Match and harmonise country names}
\usage{
countryHarmoniseR(
  data = NULL,
  countryColumn = NULL,
  shorterNames = TRUE,
  continentAnalysis = FALSE
)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{countryColumn}{Character. The column that contains country names to be harmonised.}

\item{shorterNames}{Logical. If TRUE, some very long country names will be shortened. This can be
helpful for writing country names in plots where long names are annoying.}

\item{continentAnalysis}{Logical. Set to TRUE in order to match small entities to continents;
limited use for the moment.}
}
\value{
Returns the original data frame or tibble but with harmonised country names
}
\description{
A small function that is useful for harmonising country names so that they mathc between datasets.
This relies on the country names matching one of the exceptions pre-coded in and is so far used
internally.
}
\examples{
# load in the test dataset
system.file("extdata", "testTaxonomy.rda", package="BeeBDC") |> load()
harmonisedCountries <- countryHarmoniseR(
  data = testTaxonomy,
  countryColumn = "country_suggested"
)
}
