% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performanceassess.R, R/plotS3.R,
%   R/printmethods.R, R/summary.R
\name{samplecomp}
\alias{samplecomp}
\alias{plot.samplecomp}
\alias{print.samplecomp}
\alias{summary.samplecomp}
\title{Performance assessment of sampling algorithms against a known Bayesian network}
\usage{
samplecomp(
  MCMCchain,
  truedag,
  p = c(0.99, 0.95, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2),
  pdag = TRUE,
  burnin = 0.2,
  trans = TRUE
)

\method{plot}{samplecomp}(x, ..., vars = c("FP", "TP"), type = "b", col = "blue", showp = NULL)

\method{print}{samplecomp}(x, ...)

\method{summary}{samplecomp}(object, ...)
}
\arguments{
\item{MCMCchain}{an object of class \code{partitionMCMC} or \code{orderMCMC}, representing the output of structure sampling function \code{\link{partitionMCMC}} or \code{\link{orderMCMC}} (the latter when parameter \code{chainout}=TRUE;}

\item{truedag}{ground truth DAG which generated the data used in the search procedure; represented by an object of class  \code{\link[graph]{graphNEL}}}

\item{p}{a vector of numeric values between 0 and 1, defining posterior probabilities according to which the edges of assessed structures are drawn, please note very low barriers can lead to very dense structures; by default 
\eqn{p=c(0.99, 0.95, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2)}}

\item{pdag}{logical, if TRUE (default) all DAGs in the MCMCchain are first converted to equivalence class (CPDAG) before the averaging}

\item{burnin}{number between \code{0} and \code{1}, indicates the percentage of the samples which will be  the discarded as `burn-in' of the MCMC chain; the rest  of the samples will be used to calculate the posterior probabilities; 0.2 by default}

\item{trans}{logical, for DBNs indicates if model comparions are performed for transition structure; when \code{trans} equals FALSE the comparison is performed for initial structures of estimated models and the ground truth DBN; for usual BNs the parameter is disregarded}

\item{x}{object of class 'samplecomp'}

\item{...}{ignored}

\item{vars}{a tuple of variables which will be used for 'x' and 'y' axes; possible values: "SHD", "TP", "FP", "TPR", "FPR", "FPRn", "FDR"}

\item{type}{type of line in the plot; "b" by default}

\item{col}{colour of line in the plotl; "blue" by default}

\item{showp}{logical, defines if points are labelled with the posterior threshold corresponding to the assessed model}

\item{object}{object of class 'samplecomp'}
}
\value{
an object if class \code{samplesim}, a matrix with the number of rows equal to the number of elements in 'p', and 8 columns reporting for 
the consensus graphss (corresponfing to each of the values in 'p') the number of true positive edges ('TP'), the number of false positive edges ('FP'), the number of false negative edges ('FN'),
the true positive rate ('TPR'), the structural Hamming distance ('SHD'), false positive rate ('FPR'),
false discovery rate ('FDR') and false positive rate normalized by TP+FN ('FPRn').
}
\description{
This function compute 8 different metrics of structure fit of an object of classes \code{orderMCMC} and \code{partitionMCMC} to the ground truth DAG (or CPDAG). First posterior probabilities
of single edges are calculated based on a sample stores in the object of class \code{orderMCMC} or \code{partitionMCMC}. This function computes structure fit of
each of the consensus graphs to the ground truth one based on a defined range of posterior thresholds. Computed metrics include: TP, FP, TPR, FPR, FPRn, FDR, SHD. See metrics description in
see also \code{\link{compareDAGs}}.
}
\examples{
gsim.score<-scoreparameters("bge", gsim)
\dontrun{
MAPestimate<-learnBN(gsim.score,"orderIter",scoreout=TRUE)
ordersample<-sampleBN(gsim.score, "order", scoretable=getSpace(MAPestimate))
samplecomp(ordersample, gsimmat)
}
}
\author{
Polina Suter
}
