% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinomialEMVS.R
\name{BinomialEMVS}
\alias{BinomialEMVS}
\title{Variable Selection For Binary Data Using The EM Algorithm}
\usage{
BinomialEMVS(y, x, type = "probit", epsilon = 5e-04, v0s = ifelse(type ==
  "probit", 0.025, 5), nu.1 = ifelse(type == "probit", 100, 1000),
  nu.gam = 1, lambda.var = 0.001, a = 1, b = ncol(x),
  beta.initial = NULL, sigma.initial = 1, theta.inital = 0.5, temp = 1,
  p = ncol(x), n = nrow(x), SDCD.length = 50)
}
\arguments{
\item{y}{responses in 0-1 coding}

\item{x}{X matrix}

\item{type}{probit or logit model}

\item{epsilon}{tuning parameter}

\item{v0s}{tuning parameter, can be vector}

\item{nu.1}{tuning parameter}

\item{nu.gam}{tuning parameter}

\item{lambda.var}{tuning parameter}

\item{a}{tuning parameter}

\item{b}{tuning parameter}

\item{beta.initial}{starting values}

\item{sigma.initial}{starting value}

\item{theta.inital}{startng value}

\item{temp}{not sure}

\item{p}{not sure}

\item{n}{not sure}

\item{SDCD.length}{not sure}
}
\value{
probs is posterior probabilities
}
\description{
Conducts EMVS analysis
}
\examples{
#Generate data
set.seed(1)
n=25;p=500;pr=10;cor=.6
X=data.sim(n,p,pr,cor)

#Randomly generate related beta coefficnets from U(-1,1)
beta.Vec=rep(0,times=p)
beta.Vec[1:pr]=runif(pr,-1,1)

y=scale(X\%*\%beta.Vec+rnorm(n,0,sd=sqrt(3)),center=TRUE,scale=FALSE)
prob=1/(1+exp(-y))
y.bin=t(t(ifelse(rbinom(n,1,prob)>0,1,0)))

result.probit=BinomialEMVS(y=y.bin,x=X,type="probit")
result.logit=BinomialEMVS(y=y.bin,x=X,type="logit")

which(result.probit$posts>.5)
which(result.logit$posts>.5)

}

