% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{cat_summary}
\alias{cat_summary}
\title{Summarize Categorical Variables in Subgroup}
\usage{
cat_summary(
  yvar,
  yname,
  xvars,
  xname.list,
  data,
  yvar.display = yvar,
  xvars.display = xvars
)
}
\arguments{
\item{yvar}{Name of the variable for summary.}

\item{yname}{A vector of ordered y values.}

\item{xvars}{Names of the variables for grouping.}

\item{xname.list}{A list (same order as xvars) of ordered x values for each xvar.}

\item{data}{The dataset.}

\item{yvar.display}{Display name for yvar.}

\item{xvars.display}{Display name for xvars.}
}
\value{
A list containing the contingency table, frequency table, and percentage table.
}
\description{
This function provides a summary of categorical variables in a dataset.
}
\examples{
# Load a sample dataset
data <- data.frame(
  outcome = sample(c("A", "B", "C"), 100, replace = TRUE),  # categorical outcome
  group1 = sample(c("Male", "Female"), 100, replace = TRUE),  # group variable 1
  group2 = sample(c("Young", "Old"), 100, replace = TRUE)  # group variable 2
)

# Summarize categorical outcome by two grouping variables
cat_summary(
  yvar = "outcome",
  yname = c("A", "B", "C"),  # ordered categories for outcome
  xvars = c("group1", "group2"),
  xname.list = list(c("Male", "Female"), c("Young", "Old")),
  data = data,
  yvar.display = "Outcome Category",
  xvars.display = c("Gender", "Age Group")
)
}
