% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col.sto.R
\name{col.sto}
\alias{col.sto}
\title{Turns a Migration Matrix into a Column Stochastic Matrix}
\usage{
col.sto(x)
}
\arguments{
\item{x}{the raw data migration matrix}
}
\value{
col.sto is used on a an object of class "matrix" and returns an object of class "matrix".
}
\description{
Calculates the column stochastic matrix starting from the raw migration matrix \code{x}. For each column, it divides each term by the column sum. Then it returns the thus "normalized by column" matrix, ready to be used in the Malecot migration model.
}
\details{
The Malecot model uses a transformation of the raw migration data; in the "Malecot" library the use of a column stochastic matrix follows Imaizumi 1970 and Swedlund 1984.
}
\examples{
data(raw.mig)
new.mig.mat<-col.sto(raw.mig)
new.mig.mat

}
\references{
Imaizumi, Y., N. E. Morton and D. E. Harris. 1970. Isolation by distance in artificial populations. Genetics 66: 569-582.

Jorde, L. B. 1982. The genetic structure of the Utah mormons: migration analysis. Human Biology 54(3): 583-597.
}
\author{
Federico C. F. Calboli \email{f.calboli@gmail.com}
}
