// Copyright 2018 Google LLC. All Rights Reserved.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

// This file was automatically generated by the program contained in the source
// file write_poisson_mixture_tables.cpp.
#include <vector>
#include "LinAlg/Vector.hpp"
#include "Models/Glm/PosteriorSamplers/NormalMixtureApproximation.hpp"

namespace BOOM {
  void fill_poisson_mixture_approximation_table_1(
      NormalMixtureApproximationTable *table) {
    //----------------------------------------------------------------------
    // nu = 1 kl = 1.55587e-05
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-1.10017, 4.63951, 3.13821, 2.10282, 0.885889, 0.174309,
                       -0.465988, 0.228799, 0.671705, 2.71379}),
          BOOM::Vector({0.383782, 2.17443, 1.42327, 0.586083, 0.719241, 0.508172,
                       0.464148, 0.446046, 0.628454, 0.814524}),
          BOOM::Vector({0.051647, 0.00554244, 0.0441814, 0.0478747, 0.356135,
                       0.0856119, 0.256498, 0.0887642, 0.0172381, 0.0465076}));
      table->add(1, spec);
    }

    //----------------------------------------------------------------------
    // nu = 2 kl = 8.45545e-05
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-1.3477, 0.858862, -0.928641, -0.780994, 0.33308,
                       -0.00631014, -0.812043, -0.413538, -0.236343, -0.267196}),
          BOOM::Vector({0.353737, 1.09171, 0.422356, 0.445879, 0.718825, 0.622078,
                       0.423838, 0.529212, 0.476274, 0.516796}),
          BOOM::Vector({0.107311, 0.0467586, 0.0830307, 0.108579, 0.149063,
                       0.0845241, 0.153324, 0.078107, 0.0596707, 0.129633}));
      table->add(2, spec);
    }

    //----------------------------------------------------------------------
    // nu = 3 kl = -9.23107e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-0.22326, -0.10081, -1.11593, -0.743897, -1.47646, -1.23108,
                       -0.669934, -1.01269, 0.400115, -1.82461}),
          BOOM::Vector({0.40346, 0.628081, 0.294969, 0.404837, 0.293553, 0.367995,
                       0.343763, 0.393868, 0.881989, 0.277423}),
          BOOM::Vector({0.0793824, 0.0953603, 0.109487, 0.217827, 0.172565,
                       0.0638406, 0.0379442, 0.164582, 0.00983275, 0.0491789}));
      table->add(3, spec);
    }

    //----------------------------------------------------------------------
    // nu = 4 kl = 8.98929e-05
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-1.10537, -1.05435, -1.583, -1.9239, -0.963913, -1.06215,
                       -1.42551, -0.684022, -1.23966, -1.5737}),
          BOOM::Vector({0.44342, 0.438956, 0.295335, 0.264879, 0.448243, 0.43186,
                       0.345451, 0.636252, 0.309343, 0.276064}),
          BOOM::Vector({0.0935312, 0.103366, 0.113602, 0.0930069, 0.0926803,
                       0.0884835, 0.0626031, 0.111189, 0.131113, 0.110425}));
      table->add(4, spec);
    }

    //----------------------------------------------------------------------
    // nu = 5 kl = 1.47037e-05
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-1.5118, -1.22628, -1.63669, -1.33663, -0.906453, -1.80417,
                       -1.25535, -2.04477, -1.50231, -1.14495}),
          BOOM::Vector({0.313541, 0.414644, 0.276942, 0.344436, 0.576564, 0.22352,
                       0.409026, 0.256978, 0.300562, 0.427996}),
          BOOM::Vector({0.112605, 0.0887378, 0.139101, 0.0850069, 0.0536112,
                       0.0878054, 0.070821, 0.153145, 0.104148, 0.105019}));
      table->add(5, spec);
    }

    //----------------------------------------------------------------------
    // nu = 6 kl = 3.89138e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-1.17601, -1.63461, -1.83448, -2.28023, -1.47591, -1.67298,
                       -1.46829, -1.18444, -2.03269, -1.51588}),
          BOOM::Vector({0.523049, 0.291187, 0.198541, 0.225656, 0.280095, 0.211637,
                       0.332143, 0.344228, 0.217072, 0.301913}),
          BOOM::Vector({0.0467676, 0.152629, 0.0971597, 0.0851477, 0.120512,
                       0.0994461, 0.0481825, 0.0946917, 0.222209, 0.0332553}));
      table->add(6, spec);
    }

    //----------------------------------------------------------------------
    // nu = 7 kl = 4.38059e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-1.95409, -1.5987, -2.38938, -1.88714, -1.67858, -1.26291,
                       -2.22767, -1.36283, -2.03974, -1.79702}),
          BOOM::Vector({0.24874, 0.31425, 0.217831, 0.268854, 0.307241, 0.497019,
                       0.196812, 0.367221, 0.214022, 0.24747}),
          BOOM::Vector({0.0979245, 0.111223, 0.089909, 0.093848, 0.15818, 0.0138501,
                       0.0928954, 0.0722608, 0.157491, 0.112417}));
      table->add(7, spec);
    }

    //----------------------------------------------------------------------
    // nu = 8 kl = 1.29294e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.30217, -2.15613, -1.91148, -1.54833, -1.85478, -2.47531,
                       -2.04351, -1.65014, -2.10472, -1.76658}),
          BOOM::Vector({0.194811, 0.223825, 0.274489, 0.443433, 0.258878, 0.211065,
                       0.251567, 0.332834, 0.221687, 0.322762}),
          BOOM::Vector({0.0993276, 0.0975451, 0.134871, 0.0321373, 0.103546,
                       0.103078, 0.124797, 0.0994464, 0.118788, 0.0864636}));
      table->add(8, spec);
    }

    //----------------------------------------------------------------------
    // nu = 9 kl = 4.53982e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.5401, -2.29312, -2.08495, -2.15647, -2.30637, -1.91603,
                       -2.03128, -1.85113, -1.77696, -2.29659}),
          BOOM::Vector({0.209626, 0.231174, 0.274278, 0.258245, 0.231812, 0.301126,
                       0.233743, 0.294184, 0.400296, 0.222109}),
          BOOM::Vector({0.102804, 0.0822189, 0.0894677, 0.112456, 0.0944807,
                       0.113298, 0.112262, 0.0896138, 0.0656408, 0.137758}));
      table->add(9, spec);
    }

    //----------------------------------------------------------------------
    // nu = 10 kl = 3.83057e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.16845, -2.25588, -2.19865, -1.90242, -2.06094, -2.11239,
                       -1.84307, -2.51369, -2.36089, -2.65598}),
          BOOM::Vector({0.248697, 0.202707, 0.25112, 0.293086, 0.250231, 0.243349,
                       0.391287, 0.175322, 0.176943, 0.194795}),
          BOOM::Vector({0.0923346, 0.171586, 0.0723437, 0.110928, 0.095274,
                       0.0821783, 0.0265003, 0.131075, 0.109546, 0.108234}));
      table->add(10, spec);
    }

    //----------------------------------------------------------------------
    // nu = 11 kl = 8.47546e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.22232, -2.29665, -2.16183, -2.39302, -2.57522, -2.25139,
                       -1.98906, -2.00743, -2.74873, -2.39589}),
          BOOM::Vector({0.260293, 0.238146, 0.215392, 0.1938, 0.182653, 0.234875,
                       0.258872, 0.362308, 0.186749, 0.209153}),
          BOOM::Vector({0.0927876, 0.100831, 0.0752709, 0.124486, 0.174055,
                       0.0721123, 0.0836925, 0.0444238, 0.0863255, 0.146014}));
      table->add(11, spec);
    }

    //----------------------------------------------------------------------
    // nu = 12 kl = 4.29371e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.19049, -2.3886, -2.27972, -2.53907, -2.32686, -2.64601,
                       -2.48734, -2.80491, -2.27897, -2.46083}),
          BOOM::Vector({0.335353, 0.245024, 0.254954, 0.208269, 0.251906, 0.166496,
                       0.199451, 0.180348, 0.257982, 0.199256}),
          BOOM::Vector({0.104595, 0.0904034, 0.0878298, 0.082432, 0.102242,
                       0.103936, 0.101115, 0.103654, 0.0978934, 0.1259}));
      table->add(12, spec);
    }

    //----------------------------------------------------------------------
    // nu = 13 kl = 3.09935e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.50814, -2.87985, -2.5114, -2.56513, -2.25455, -2.21383,
                       -2.45251, -2.72674, -2.49844, -2.39733}),
          BOOM::Vector({0.219854, 0.176586, 0.220641, 0.165629, 0.250955, 0.330506,
                       0.218216, 0.167059, 0.219848, 0.224279}),
          BOOM::Vector({0.0971237, 0.094922, 0.0993836, 0.102112, 0.132761,
                       0.0389869, 0.0846605, 0.16732, 0.0984257, 0.0843056}));
      table->add(13, spec);
    }

    //----------------------------------------------------------------------
    // nu = 14 kl = 1.53499e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.71819, -2.39403, -2.91088, -2.58549, -2.34768, -2.46503,
                       -2.61749, -2.47247, -2.60676, -2.75375}),
          BOOM::Vector({0.188596, 0.238503, 0.177131, 0.202064, 0.309244, 0.239031,
                       0.209365, 0.241211, 0.210188, 0.169953}),
          BOOM::Vector({0.0887803, 0.0968716, 0.119126, 0.118051, 0.0737052,
                       0.0877944, 0.0936813, 0.0792559, 0.145228, 0.0975057}));
      table->add(14, spec);
    }

    //----------------------------------------------------------------------
    // nu = 15 kl = 1.33612e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.83187, -2.97929, -2.5351, -2.693, -2.72854, -2.63332,
                       -2.62734, -2.71848, -2.43859, -2.47099}),
          BOOM::Vector({0.161589, 0.170474, 0.233919, 0.200019, 0.193735, 0.220349,
                       0.210566, 0.196697, 0.298003, 0.230645}),
          BOOM::Vector({0.0999033, 0.109203, 0.11753, 0.104285, 0.112205, 0.0805466,
                       0.0967948, 0.107108, 0.0773693, 0.0950548}));
      table->add(15, spec);
    }

    //----------------------------------------------------------------------
    // nu = 16 kl = 4.40761e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.78261, -2.49315, -2.69906, -3.03961, -2.49316, -2.79538,
                       -2.63364, -2.72594, -2.92355, -2.7082}),
          BOOM::Vector({0.187353, 0.217334, 0.200883, 0.16552, 0.290165, 0.155372,
                       0.199695, 0.201618, 0.150474, 0.195079}),
          BOOM::Vector({0.0955543, 0.119762, 0.0962062, 0.115448, 0.0557457,
                       0.0966131, 0.101652, 0.0996282, 0.108908, 0.110482}));
      table->add(16, spec);
    }

    //----------------------------------------------------------------------
    // nu = 17 kl = 2.85303e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.86147, -2.54106, -2.98934, -2.56169, -2.69321, -2.86739,
                       -2.77851, -2.76546, -2.74476, -3.10841}),
          BOOM::Vector({0.157162, 0.209479, 0.149403, 0.281295, 0.193017, 0.175629,
                       0.192595, 0.200924, 0.197301, 0.159568}),
          BOOM::Vector({0.0977126, 0.0974159, 0.111694, 0.0511133, 0.0967194,
                       0.117931, 0.113648, 0.105572, 0.115429, 0.0927649}));
      table->add(17, spec);
    }

    //----------------------------------------------------------------------
    // nu = 18 kl = 2.88659e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.70424, -2.67037, -2.83261, -2.89881, -3.14233, -2.80686,
                       -2.81421, -2.92335, -2.63058, -3.02756}),
          BOOM::Vector({0.215005, 0.215035, 0.189501, 0.176083, 0.158559, 0.183899,
                       0.190533, 0.157471, 0.272262, 0.148654}),
          BOOM::Vector({0.0918774, 0.105924, 0.0945922, 0.1111, 0.111545, 0.11282,
                       0.0979044, 0.111961, 0.0510972, 0.111179}));
      table->add(18, spec);
    }

    //----------------------------------------------------------------------
    // nu = 19 kl = 1.04033e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.04786, -2.79218, -2.95496, -2.72309, -2.94398, -2.83479,
                       -3.18163, -2.81501, -2.89527, -2.95439}),
          BOOM::Vector({0.150927, 0.209676, 0.179842, 0.259399, 0.177905, 0.211588,
                       0.156208, 0.21029, 0.194266, 0.179479}),
          BOOM::Vector({0.101883, 0.127502, 0.0992203, 0.087471, 0.0921502,
                       0.0918428, 0.105798, 0.0906732, 0.0782149, 0.125244}));
      table->add(19, spec);
    }

    //----------------------------------------------------------------------
    // nu = 20 kl = 1.95135e-05
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.96542, -2.94527, -2.8337, -3.13593}),
          BOOM::Vector({0.196234, 0.187911, 0.240907, 0.168479}),
          BOOM::Vector({0.264079, 0.251065, 0.23993, 0.244925}));
      table->add(20, spec);
    }

    //----------------------------------------------------------------------
    // nu = 21 kl = 1.25501e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.21395, -2.9257, -2.79684, -3.05254}),
          BOOM::Vector({0.160645, 0.199949, 0.239806, 0.166301}),
          BOOM::Vector({0.208282, 0.390199, 0.0631345, 0.338385}));
      table->add(21, spec);
    }

    //----------------------------------------------------------------------
    // nu = 22 kl = 9.95333e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-2.86939, -3.12875, -2.97884, -3.28986}),
          BOOM::Vector({0.23555, 0.171039, 0.195224, 0.152216}),
          BOOM::Vector({0.0750799, 0.444956, 0.380877, 0.0990878}));
      table->add(22, spec);
    }

    //----------------------------------------------------------------------
    // nu = 23 kl = 1.07408e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.14447, -3.03371, -3.29641, -2.90364}),
          BOOM::Vector({0.157386, 0.192051, 0.154507, 0.227346}),
          BOOM::Vector({0.297551, 0.42609, 0.211001, 0.0653575}));
      table->add(23, spec);
    }

    //----------------------------------------------------------------------
    // nu = 24 kl = 7.97378e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.3425, -3.19125, -2.93168, -3.05843}),
          BOOM::Vector({0.151682, 0.162609, 0.221468, 0.188103}),
          BOOM::Vector({0.172572, 0.420153, 0.0487638, 0.358511}));
      table->add(24, spec);
    }

    //----------------------------------------------------------------------
    // nu = 25 kl = 7.77405e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.01992, -3.39868, -3.24511, -3.08839}),
          BOOM::Vector({0.219514, 0.145746, 0.163358, 0.17772}),
          BOOM::Vector({0.0799961, 0.109955, 0.521404, 0.288645}));
      table->add(25, spec);
    }

    //----------------------------------------------------------------------
    // nu = 26 kl = 7.05901e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.06494, -3.13075, -3.2832, -3.43299}),
          BOOM::Vector({0.214884, 0.174372, 0.160391, 0.143716}),
          BOOM::Vector({0.0802951, 0.28768, 0.519044, 0.11298}));
      table->add(26, spec);
    }

    //----------------------------------------------------------------------
    // nu = 27 kl = 6.71093e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.11417, -3.325, -3.19994, -3.46592}),
          BOOM::Vector({0.210819, 0.15283, 0.175212, 0.141729}),
          BOOM::Vector({0.0870154, 0.399954, 0.382538, 0.130493}));
      table->add(27, spec);
    }

    //----------------------------------------------------------------------
    // nu = 28 kl = 5.55738e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.48618, -3.3487, -3.23148, -3.12311}),
          BOOM::Vector({0.141835, 0.150604, 0.174175, 0.204322}),
          BOOM::Vector({0.167048, 0.396213, 0.379249, 0.0574893}));
      table->add(28, spec);
    }

    //----------------------------------------------------------------------
    // nu = 29 kl = 6.26874e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.22416, -3.17597, -3.5103, -3.36949}),
          BOOM::Vector({0.161478, 0.201, 0.141115, 0.150377}),
          BOOM::Vector({0.228483, 0.0707529, 0.194295, 0.506469}));
      table->add(29, spec);
    }

    //----------------------------------------------------------------------
    // nu = 30 kl = 9.31351e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.53716, -3.296, -3.40811, -3.25089}),
          BOOM::Vector({0.138433, 0.157926, 0.137968, 0.198364}),
          BOOM::Vector({0.239853, 0.311762, 0.323243, 0.125142}));
      table->add(30, spec);
    }

    //----------------------------------------------------------------------
    // nu = 31 kl = 5.40522e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.30406, -3.43753, -3.57137, -3.25426}),
          BOOM::Vector({0.157096, 0.14466, 0.137224, 0.193906}),
          BOOM::Vector({0.247653, 0.477233, 0.200927, 0.074188}));
      table->add(31, spec);
    }

    //----------------------------------------------------------------------
    // nu = 32 kl = 1.83494e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.47206, -3.59097, -3.3608, -3.34302}),
          BOOM::Vector({0.127225, 0.134355, 0.143781, 0.190057}),
          BOOM::Vector({0.262988, 0.275631, 0.266175, 0.195207}));
      table->add(32, spec);
    }

    //----------------------------------------------------------------------
    // nu = 33 kl = 1.74988e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.63039, -3.39652, -3.51067, -3.37979}),
          BOOM::Vector({0.130819, 0.142221, 0.126932, 0.187349}),
          BOOM::Vector({0.233177, 0.269683, 0.294478, 0.202661}));
      table->add(33, spec);
    }

    //----------------------------------------------------------------------
    // nu = 34 kl = 1.91619e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.66024, -3.54621, -3.44422, -3.41632}),
          BOOM::Vector({0.128445, 0.122684, 0.142192, 0.184388}),
          BOOM::Vector({0.227178, 0.238719, 0.316899, 0.217204}));
      table->add(34, spec);
    }

    //----------------------------------------------------------------------
    // nu = 35 kl = 2.4272e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.45333, -3.47375, -3.57858, -3.69033}),
          BOOM::Vector({0.181102, 0.137254, 0.119576, 0.125799}),
          BOOM::Vector({0.246407, 0.296997, 0.238148, 0.218447}));
      table->add(35, spec);
    }

    //----------------------------------------------------------------------
    // nu = 36 kl = 9.03495e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.46691, -3.72351, -3.6068, -3.49929}),
          BOOM::Vector({0.1796, 0.125171, 0.126406, 0.142434}),
          BOOM::Vector({0.17033, 0.179811, 0.329946, 0.319914}));
      table->add(36, spec);
    }

    //----------------------------------------------------------------------
    // nu = 37 kl = 1.00391e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.61444, -3.51887, -3.49594, -3.7235}),
          BOOM::Vector({0.120991, 0.137913, 0.176566, 0.127275}),
          BOOM::Vector({0.252224, 0.289143, 0.173494, 0.285139}));
      table->add(37, spec);
    }

    //----------------------------------------------------------------------
    // nu = 38 kl = 6.04446e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.51812, -3.5603, -3.65507, -3.76597}),
          BOOM::Vector({0.174583, 0.14181, 0.123721, 0.123863}),
          BOOM::Vector({0.146419, 0.350147, 0.300214, 0.203221}));
      table->add(38, spec);
    }

    //----------------------------------------------------------------------
    // nu = 39 kl = 4.68814e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.54317, -3.58864, -3.68474, -3.79577}),
          BOOM::Vector({0.172549, 0.141695, 0.124397, 0.122032}),
          BOOM::Vector({0.134179, 0.360045, 0.329741, 0.176035}));
      table->add(39, spec);
    }

    //----------------------------------------------------------------------
    // nu = 40 kl = 1.98959e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.68816, -3.79375, -3.60942, -3.58782}),
          BOOM::Vector({0.121886, 0.124039, 0.135526, 0.168426}),
          BOOM::Vector({0.257529, 0.277002, 0.260389, 0.20508}));
      table->add(40, spec);
    }

    //----------------------------------------------------------------------
    // nu = 41 kl = 3.80594e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.59369, -3.62076, -3.72969, -3.84174}),
          BOOM::Vector({0.167718, 0.135457, 0.1248, 0.119954}),
          BOOM::Vector({0.127238, 0.276005, 0.427154, 0.169603}));
      table->add(41, spec);
    }

    //----------------------------------------------------------------------
    // nu = 42 kl = 3.82951e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.62167, -3.75431, -3.65586, -3.86188}),
          BOOM::Vector({0.165586, 0.121414, 0.135013, 0.11882}),
          BOOM::Vector({0.132126, 0.368265, 0.314571, 0.185038}));
      table->add(42, spec);
    }

    //----------------------------------------------------------------------
    // nu = 43 kl = 3.97626e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.65898, -3.86544, -3.75917, -3.64107}),
          BOOM::Vector({0.129864, 0.120191, 0.11909, 0.162826}),
          BOOM::Vector({0.240719, 0.272621, 0.363895, 0.122765}));
      table->add(43, spec);
    }

    //----------------------------------------------------------------------
    // nu = 44 kl = 2.80783e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.78941, -3.89013, -3.72035, -3.65658}),
          BOOM::Vector({0.11587, 0.118651, 0.137201, 0.160976}),
          BOOM::Vector({0.238061, 0.248387, 0.416636, 0.0969155}));
      table->add(44, spec);
    }

    //----------------------------------------------------------------------
    // nu = 45 kl = 2.55462e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.81316, -3.74376, -3.68008, -3.91278}),
          BOOM::Vector({0.115294, 0.135939, 0.159032, 0.117355}),
          BOOM::Vector({0.24792, 0.417027, 0.0949106, 0.240143}));
      table->add(45, spec);
    }

    //----------------------------------------------------------------------
    // nu = 46 kl = 2.66128e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.73393, -3.93083, -3.7034, -3.82829}),
          BOOM::Vector({0.128576, 0.116838, 0.156829, 0.117263}),
          BOOM::Vector({0.26287, 0.257823, 0.0976207, 0.381685}));
      table->add(46, spec);
    }

    //----------------------------------------------------------------------
    // nu = 47 kl = 1.47922e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.84796, -3.94334, -3.77286, -3.76275}),
          BOOM::Vector({0.113791, 0.116108, 0.124328, 0.155116}),
          BOOM::Vector({0.261941, 0.288034, 0.236086, 0.213939}));
      table->add(47, spec);
    }

    //----------------------------------------------------------------------
    // nu = 48 kl = 3.12752e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.76952, -3.98498, -3.88842, -3.80743}),
          BOOM::Vector({0.154289, 0.112206, 0.112186, 0.127838}),
          BOOM::Vector({0.143959, 0.195912, 0.296249, 0.363879}));
      table->add(48, spec);
    }

    //----------------------------------------------------------------------
    // nu = 49 kl = 1.59178e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.80908, -3.81053, -3.98866, -3.89524}),
          BOOM::Vector({0.150898, 0.118717, 0.11317, 0.1122}),
          BOOM::Vector({0.238816, 0.199434, 0.254894, 0.306856}));
      table->add(49, spec);
    }
  }
}  // namespace BOOM
