% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PooledCRD.R
\name{PooledCRD}
\alias{PooledCRD}
\title{Pooled Completely Randomized Design Analysis}
\usage{
PooledCRD(data, Response, Location, Treatment, alpha, Mult_Comp_Test)
}
\arguments{
\item{data}{A data frame containing the experimental data.}

\item{Response}{A numeric variable representing the dependent variable (response).}

\item{Location}{A factor indicating different locations or years.}

\item{Treatment}{A factor indicating the different treatments applied.}

\item{alpha}{A numeric value specifying the significance level for Bartlett’s test.}

\item{Mult_Comp_Test}{An integer specifying the type of multiple comparison test:
\itemize{
  \item 1 = Tukey's honestly significant difference (Tukey's HSD) test
  \item 2 = Duncan's multiple range test (DMRT)
  \item 3 = least significant difference (LSD) test
}}
}
\value{
A list containing the following components:
  \itemize{
    \item \strong{Individual_ANOVA}: Summary of ANOVA results for each location or year.
    \item \strong{Location_wise}: Multiple comparisons of treatments within each location or year.
    \item \strong{Bartlett_Test}: Results of Bartlett's test for homogeneity of variances.
    \item \strong{Pooled_ANOVA}: Combined (pooled) ANOVA table across all locations or years.
    \item \strong{Treatments_Comparison}: Summary of pooled treatment comparisons using the selected multiple comparison test.
  }
}
\description{
This function performs pooled analysis of variance (ANOVA) using the completely randomized design (CRD) for multiple locations or years. For more details see Montgomery (2017), Dean et al. (2017)<doi:10.1007/978-3-319-52250-0> and Ruíz et al. (2024)<doi:10.1007/978-3-031-65575-3>.
}
\examples{
# Creating a sample dataset for Pooled Completely Randomized Design (CRD)
df <- data.frame(
  Loc = factor(rep(c("L1", "L2"), each = 9)),  # Locations
  Treatment = factor(rep(c("T1", "T2", "T3"), times = 6)),  # Treatments
  Yield = c(18, 7, 11, 10, 19, 12, 15, 8, 13, 
            18, 5, 11, 7, 19, 21, 22, 9, 14)  # Yield values
)

# Running PooledCRD function on the dataset
out <- PooledCRD(df, "Yield", "Loc", "Treatment", 0.05, 1)

# Print results
print(out)
}
\references{
Dean A, Voss D, Draguljic D (2017)<doi:10.1007/978-3-319-52250-0>.

Montgomery DC (2017). \emph{Design and Analysis of Experiments}. John wiley & sons.

Ruíz JS, López OAM, Crossa J (2024)<doi:10.1007/978-3-031-65575-3>.
}
