% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBPLogisticE.R
\name{CBPLogisticE}
\alias{CBPLogisticE}
\title{Correlation-based Estimator for Logistic Regression Models}
\usage{
CBPLogisticE(X, y, lambda, max_iter = 100, tol = 1e-06)
}
\arguments{
\item{X}{A numeric matrix of predictors where rows represent observations and columns represent variables.}

\item{y}{A numeric vector of binary outcomes (0 or 1).}

\item{lambda}{A regularization parameter.}

\item{max_iter}{An integer specifying the maximum number of iterations for the logistic regression algorithm. Default is 100.}

\item{tol}{A numeric value specifying the convergence tolerance for the logistic regression algorithm. Default is 1e-10.}
}
\value{
A numeric vector of the estimated coefficients for the specified model.
}
\description{
This function computes the correlation-based estimator for logistic regression models.
}
\details{
The correlation-based penalized logistic estimator is calculated as:
\deqn{
\hat{\beta} = \text{argmin}\left\{ \sum_{i=1}^n \left( y_i \ln(\pi_i) + (1 - y_i) \ln(1 - \pi_i) \right) + \lambda \sum_{i=1}^{p-1} \sum_{j>i} \left( \frac{(\beta_i - \beta_j)^2}{1 - \rho_{ij}} + \frac{(\beta_i + \beta_j)^2}{1 + \rho_{ij}} \right) \right\}
}
where \eqn{\pi_i = \text{Pr}(y_i = 1|\mathbf{x}_i)} and \eqn{\rho_{ij}} denotes the (empirical) correlation between the \eqn{i}th and the \eqn{j}th predictor.
}
\examples{
set.seed(42)
n <- 100
p <- 4
X <- matrix(rnorm(n * p), n, p)
beta_true <- c(0.5, -1, 2, 5)
y <- rbinom(n, 1, 1 / (1 + exp(-X \%*\% beta_true)))
lambda <- 0.1

result <- CBPLogisticE(X, y, lambda)
print(result)

}
\references{
Algamal, Z. Y., & Lee, M. H. (2015). Penalized logistic regression with the adaptive LASSO for gene selection in high-dimensional cancer classification. Expert Systems with Applications, 42(23), 9326-9332.
}
