% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_RefGrid.R
\name{add_RefGrid}
\alias{add_RefGrid}
\title{Add a Reference grid}
\usage{
add_RefGrid(
  bb,
  ResLat = 1,
  ResLon = 2,
  LabLon = NA,
  LatR = c(-80, -45),
  lwd = 1,
  lcol = "black",
  fontsize = 1,
  fontcol = "black",
  offset = NA
)
}
\arguments{
\item{bb}{bounding box of the first plotted object. for example, \code{bb=st_bbox(SmallBathy())} or \code{bb=st_bbox(MyPolys)}.}

\item{ResLat}{numeric, latitude resolution in decimal degrees.}

\item{ResLon}{numeric, longitude resolution in decimal degrees.}

\item{LabLon}{numeric, longitude at which Latitude labels should appear. if set, the resulting Reference grid will be circumpolar.}

\item{LatR}{numeric, range of latitudes of circumpolar grid.}

\item{lwd}{numeric, line thickness of the Reference grid.}

\item{lcol}{character, line color of the Reference grid.}

\item{fontsize}{numeric, font size of the Reference grid's labels.}

\item{fontcol}{character, font color of the Reference grid's labels.}

\item{offset}{numeric, offset of the Reference grid's labels (distance to plot border).}
}
\description{
Add a Latitude/Longitude reference grid to maps.
}
\examples{
library(terra)

#Example 1: Circumpolar grid with Latitude labels at Longitude 0

plot(SmallBathy(),breaks=Depth_cuts, col=Depth_cols, legend=FALSE,axes=FALSE,box=FALSE)
add_RefGrid(bb=st_bbox(SmallBathy()),ResLat=10,ResLon=20,LabLon = 0)

#Example 2: Local grid around created polygons

MyPolys=create_Polys(PolyData,Densify=TRUE)
BathyC=crop(SmallBathy(),ext(MyPolys))#crop the bathymetry to match the extent of MyPolys
Mypar=par(mai=c(0.5,0.5,0.5,0.5)) #Figure margins as c(bottom, left, top, right)
par(Mypar)
plot(BathyC,breaks=Depth_cuts, col=Depth_cols, legend=FALSE,axes=FALSE,box=FALSE)
add_RefGrid(bb=st_bbox(BathyC),ResLat=2,ResLon=6)
plot(st_geometry(MyPolys),add=TRUE,col='orange',border='brown',lwd=2)

}
\seealso{
\code{\link{load_Bathy}}, \code{\link{SmallBathy}}, \code{\link{add_Legend}}.
}
