\name{CDFt}
\title{Downscaling or bias correction of CDF through CDF-transformation}
\usage{
CDFt(ObsRp, DataGp, DataGf, npas=1000, dev=2)
}
\alias{CDFt}
\description{
  Downscales (or corrects the model outputs) cumulative distribution function (CDF) of a climate variable from large- to local-scale by applying a equivalent of proportionality transformation :
  i.e., based on a CDF representing a variable at large scale (i.e., low spatial resolution)
  and the equivalent CDF at a local scale (e.g., modeled at a weather station), this method finds a mathematical transformation allowing to go from the large- to the local-scale CDF. Hence, when a new large-scale CDF is given, a new local-scale CDF is downscaled based on this transformation.
}
\arguments{
  \item{ObsRp}{Observed time series of the variable (e.g., temperature) at the local scale to be used for estimation of the calibration local-scale CDF.}
  \item{DataGp}{Large-scale time series to be used for estimation of the calibration large-scale CDF.}
  \item{DataGf}{Large-scale time series to be used for estimation of the large-scale CDF to be downscaled.}
  \item{npas}{Number of "cuts" for which quantiles will be empirically estimated (Default is 1000).}
  \item{dev}{Coefficient of development (of the difference between the mean of the large-scale historical data and the mean of the large-scale future data to be downscaled). This development is used to extend range of data on which the quantiles will be calculated for the CDF to be downscaled (Default is 2).}
}
\value{
  A message is returned if the "dev" parameter is too small to capture the whole range of the downscaled CDF. Otherwise, CDFt returns a list with components
  \item{DS}{Downscaled time series generated by "Quantile-matching" method performed between large-scale CDF to be downscaled, and the local-scale downscaled CDF. Note that the length of this array is equal to the length of DataGf}
  \item{x}{an array containing values of the variable (e.g., temperature) where the downscaled (and other) CDF has been estimated.}
  \item{FRp}{an array containing the values of the local-scale CDF used for calibration, evaluated at the points in x.}
  \item{FGp}{an array containing the values of the large-scale CDF used for calibration, evaluated at the points in x.}
  \item{FGf}{an array containing the values of the large-scale CDF used for downscalingn, evaluated at the points in x.}
  \item{FRf}{an array containing the values of the downscaled CDF evaluated at the points in x.}
}
\details{For details on the mathematical formulation of the transformation used to translate the large-scale CDF to the local-scale one, see the reference below. Note that in this R package, the large-scale data (i.e., DataGp and DataGf) are automatically transformed to have the same mean as the ObsRp time series. This avoid to get out of the range of applicability of the CDFt method. However, the large-scale output CDFs have their initial mean (i.e., not centered).

P.-A. Michelangeli, M. Vrac, H. Loukos. "Probabilistic downscaling approaches: Application to wind cumulative distribution functions", Geophys. Res. Lett.,  doi:10.1029/2009GL038401, 2009.
}
\author{M. Vrac (mathieu.vrac@lsce.ipsl.fr) and P.-A. Michelangeli (pam@climpact.com)}
\seealso{\code{\link{CramerVonMisesTwoSamples}},\code{\link{KolmogorovSmirnov}}}
\examples{
## Example

### Generation of example data
O <- rnorm(2100,mean=0,sd=1)
Gp <- rnorm(300,mean=3,sd=1)
Gf <- rnorm(300,mean=4,sd=1)

### Call of the CDFt method
CT <- CDFt(O,Gp,Gf)

x <- CT$x
FGp <- CT$FGp
FGf <- CT$FGf
FRp <- CT$FRp
FRf <- CT$FRf
ds <- CT$DS

### Plot the results
par(mfrow=c(1,2))

plot(x, FGp,type="l",lty=2,ylim=c(0,1),xlab="x",ylab="CDF(x)")
lines(x,FGf,type="l",lty=2,col=2)
lines(x,FRp,type="l")
lines(x,FRf,type="l",col=2)

plot(Gf,ds,xlab="Large-scale data", ylab="Downscaled data")

}
\keyword{math}
\keyword{distribution}
\keyword{nonparametric}
\keyword{models}
