% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFbuilder.R
\name{CFbuilder}
\alias{CFbuilder}
\title{The constructor function of the CFilt class.}
\usage{
CFbuilder(Data,Datatype,similarity)

CFbuilder(
Data,
Datatype = ifelse(ncol(Data)==2,"consumption","ratings"),
similarity = ifelse(Datatype == "consumption","jaccard","pearson")
)
}
\arguments{
\item{Data}{a dataframe with 2 or 3 columns. The first column indicates the
user ID, the second the item ID and the third the rating (only if
Datatype = 'rating').}

\item{Datatype}{a character that indicates the data type: 'rating' or
'consumption'.}

\item{similarity}{a character that indicates the similarity type.
For 'datatype='ratings', 'cossine' or 'person'. For datatype='consumption',
'jaccard'.}
}
\value{
a CF class object.
}
\description{
The constructor function of the CFilt class.
}
\examples{
CF1 <- CFbuilder(Data = movies[1:300,], Datatype = "ratings", 
similarity = "pearson") #or
CF1_ <- CFbuilder(Data = movies[1:300,])
CF2 <- CFbuilder(Data = movies[1:300,], Datatype = "ratings", 
similarity = "cosine") #or
CF2_ <- CFbuilder(Data = movies[1:300,], similarity = "cosine")
CF3 <- CFbuilder(Data = movies[1:300,-3], Datatype = "consumption", 
similarity = "jaccard") #or
CF3_ <- CFbuilder(Data = movies[1:300,-3])
}
\references{
LINDEN, G.; SMITH, B.; YORK, J. Amazon. com recommendations: Item-to-item
collaborative filtering. Internet Computing, IEEE, v. 7, n. 1, p. 76-80,2003
}
\seealso{
\code{\link[CFilt]{CF-class}}
}
\author{
Jessica Kubrusly
}
\keyword{"Collaborative}
\keyword{"Cosine}
\keyword{"Jaccard}
\keyword{"Pearson}
\keyword{Filtering"}
\keyword{Silimarity"}
\keyword{Similarity"}
