% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_fastcalcassist_fs.R
\name{CGGP_internal_calcpw}
\alias{CGGP_internal_calcpw}
\title{Calculate predictive weights for CGGP}
\usage{
CGGP_internal_calcpw(CGGP, y, theta, return_lS = FALSE)
}
\arguments{
\item{CGGP}{CGGP object}

\item{y}{Measured values for CGGP$design}

\item{theta}{Correlation parameters}

\item{return_lS}{Should lS be returned?}
}
\value{
Vector with predictive weights
}
\description{
Predictive weights are Sigma^(-1)*y in standard GP.
This calculation is much faster since we don't need to
solve the full system of equations.
}
\examples{
cggp <- CGGPcreate(d=3, batchsize=100)
y <- apply(cggp$design, 1, function(x){x[1]+x[2]^2+rnorm(1,0,.01)})
CGGP_internal_calcpw(CGGP=cggp, y=y, theta=cggp$thetaMAP)
}
