% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cine.R
\name{cine}
\alias{cine}
\title{Classifies educational programs using lemmatization and CINE classification}
\usage{
cine(df, EducationProgram, filterBy)
}
\arguments{
\item{df}{Name of dataframe}

\item{EducationProgram}{Name of Education Program}

\item{filterBy}{Academic level code. Use 'AUX' for 'Auxiliar técnico', 'TEC' for 'Técnico', 'PTC' for 'Profesional técnico', 'PRF' for 'Profesional', '2DA' for 'Segunda especialidad', 'MAG' for 'Maestría' and 'PHD' for 'Doctorado'}
}
\value{
A dataframe with CINE classification result fields
}
\description{
Uses the lemmatization of the education program name to combine with the CINE dataframe.
}
\examples{
df <- data.frame(c("Administración de Negocios Internacionales",
"Ingeniería de Telecomunicaciones",
"Ingeniería Geográfica",
"Psicología Organizacional y de la Gestión Humana",
"Educación Secundaria Especialidad Lengua y Literatura",
"Educación Secundaria, Mención en: Ciencias Matemáticas",
"Ciencias de la Comunicación con Especialidad en Periodismo",
"Ingeniería Pesquera",
"Medicina Humana",
"Medicina Veterinaria",
"Carrera de Economía",
"Radiología",
"Biología - Microbiología",
"Marketing y Negocios Internacionales",
"Tecnología Médica con Especialidad en Laboratorio Clínico"))
colnames(df) <- "ProgramaEducativo"
cine(df=df, EducationProgram="ProgramaEducativo", filterBy='PRF')

}
