% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{pca_centralities}
\alias{pca_centralities}
\title{PCA Centrality Measures}
\usage{
pca_centralities(
  x,
  scale.unit = TRUE,
  cut.off = 80,
  ncp = 2,
  graph = FALSE,
  axes = c(1, 2)
)
}
\arguments{
\item{x}{a list containing the computed centrality values}

\item{scale.unit}{a boolean constant indicating whether data should be scaled to unit variance (default = TRUE)}

\item{cut.off}{The intensity that must be exceeded in cumulative percentage of variance of eigen values (default = 80)}

\item{ncp}{number of dimensions in the final results (default = 5)}

\item{graph}{a boolean constant indicating whether the graph should be displayed (default = FALSE)}

\item{axes}{a length 2 vector describing the number of components to plot (default = c(1, 2))}
}
\value{
A plot illustrating the contributions of variables to the principal components.
The x-axis represents the centrality measures, and the y-axis represents the contribution.
The higher the contribution value, the more important the centrality measure is in the ranking.
The plot helps in identifying the most influential centrality measures.
}
\description{
This function performs Principal Component Analysis (PCA) on centrality measures.
It computes the contributions of variables to the principal components and visualizes them.
}
\examples{
# Create a data frame with multiple observations
centralities <- data.frame(
  Betweenness = c(0.2, 0.3, 0.5),
 Closeness = c(0.4, 0.2, 0.6),
  Degree = c(0.3, 0.1, 0.4),
  Eigenvector = c(0.1, 0.5, 0.2)
)
pca_centralities(centralities)

}
