% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Crossplots.functions.R
\name{draw.crossplots}
\alias{draw.crossplots}
\title{Draw Crossplots}
\usage{
draw.crossplots(
  fn.mean.A,
  fn.mean.B,
  fn.sd.A,
  fn.sd.B,
  fn.pe.mean,
  fn.pe.sd,
  variables,
  ishybrid,
  num.vars
)
}
\arguments{
\item{fn.mean.A}{Enter file name of file with confidence intervals of mean stress, environment level A data. Can be hybrid, inbred, or full data set. This file needs to be obtained from the bootstrap function, run with the desired data set.}

\item{fn.mean.B}{Enter file name of file with confidence intervals of mean stress, environment level B data. Can be hybrid, inbred, or full data set. This file needs to be obtained from the bootstrap function, run with the desired data set.}

\item{fn.sd.A}{Enter file name of file with confidence intervals of SD stress, environment level A data. Can be hybrid, inbred, or full data set. This file needs to be obtained from the bootstrap function, run with the desired data set.}

\item{fn.sd.B}{Enter file name of file with confidence intervals of SD stress, environment level B data. Can be hybrid, inbred, or full data set. This file needs to be obtained from the bootstrap function, run with the desired data set.}

\item{fn.pe.mean}{Enter file name of file with point estimates of mean for each gene (both A and B environment levels present). Can be hybrid, inbred, or full data set. This file needs to be obtained from the mean_stress function, run with the desired data set.}

\item{fn.pe.sd}{Enter file name of file with point estimates of SD for each gene (both A and B environment levels present). Can be hybrid, inbred, or full data set. This file needs to be obtained from the sd.stress function, run with the desired data set.}

\item{variables}{List of variables from mean and variance models. Mean variables need to be listed first, then variance variables.}

\item{ishybrid}{Indicates the type of the data set being examined. You can use 'Hybrid', 'Inbred', "All", etc.}

\item{num.vars}{Number of variables per model. Used to ascertain if a variable falls in the mean or the variance model.}
}
\value{
There is no return for this function; it prints crossplots for each of the variables listed in the parameter 'variables.'
}
\description{
This function draws crossplots for As and Bs in each variable in the mean and variance models with the Mean Estimate vs Standard Deviation Estimate.
}
\examples{
test.data <- simu.inter.dat.interboth(n.rep = 3, n.obs.per.rep = 15, ran.seed = 1)
variables <- colnames(test.data[-1])
mean_stress(test.data, variables, 'stress')
sink();
sd.stress(test.data, variables, 'stress')
sink();
plot_vars <- c("loci_var.4","loci_var.7.env_var.2","loci_var.3",
"loci_var.5","loci_var.8.env_var.2","loci_var.4")
bootstrap(test.data, n.boot=100,variables, 'stress')
draw.crossplots('bootstrap mean A stress.txt','bootstrap mean B stress.txt',
'bootstrap sd A stress.txt', 'bootstrap sd B stress.txt', 'mean_stress.txt',
'sd_stress.txt', plot_vars, 'All',3)
unlink(c('bootstrap mean A stress.txt','bootstrap mean B stress.txt',
'bootstrap sd A stress.txt', 'bootstrap sd B stress.txt',
'mean_stress.txt', 'sd_stress.txt'))
}
