% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pnbd_pmf}
\alias{pnbd_pmf}
\alias{pnbd_nocov_PMF}
\alias{pnbd_staticcov_PMF}
\title{Pareto/NBD: Probability Mass Function (PMF)}
\usage{
pnbd_nocov_PMF(r, alpha_0, s, beta_0, x, vT_i)

pnbd_staticcov_PMF(r, s, x, vAlpha_i, vBeta_i, vT_i)
}
\arguments{
\item{r}{shape parameter of the Gamma distribution of the purchase process. The smaller r, the stronger the heterogeneity of the purchase process}

\item{alpha_0}{rate parameter of the Gamma distribution of the purchase process}

\item{s}{shape parameter of the Gamma distribution for the lifetime process. The smaller s, the stronger the heterogeneity of customer lifetimes}

\item{beta_0}{rate parameter for the Gamma distribution for the lifetime process.}

\item{x}{The number of transactions to calculate the probability for (unsigned integer).}

\item{vT_i}{Number of periods since the customer came alive.}

\item{vAlpha_i}{Vector of individual parameters alpha.}

\item{vBeta_i}{Vector of individual parameters beta.}
}
\value{
Returns a vector of probabilities.
}
\description{
Calculate P(X(t)=x), the probability that a randomly selected customer
makes exactly x transactions in the interval (0, t].
}
\references{
Schmittlein DC, Morrison DG, Colombo R (1987). \dQuote{Counting Your Customers:
Who-Are They and What Will They Do Next?} Management Science, 33(1), 1-24.

Bachmann P, Meierer M, Naef, J (2021). \dQuote{The Role of Time-Varying Contextual Factors
in Latent Attrition Models for Customer Base Analysis} Marketing Science 40(4). 783-809.

Fader PS, Hardie BGS (2005). \dQuote{A Note on Deriving the Pareto/NBD Model and
Related Expressions.}
URL \url{http://www.brucehardie.com/notes/009/pareto_nbd_derivations_2005-11-05.pdf}.

Fader PS, Hardie BGS (2007). \dQuote{Incorporating time-invariant covariates into the
Pareto/NBD and BG/NBD models.}
URL \url{http://www.brucehardie.com/notes/019/time_invariant_covariates.pdf}.

Fader PS, Hardie BGS (2020). \dQuote{Deriving an Expression for P(X(t)=x) Under
the Pareto/NBD Model.}
URL \url{https://www.brucehardie.com/notes/012/pareto_NBD_pmf_derivation_rev.pdf}
}
