% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMS_cv.R
\name{FMS_cv}
\alias{FMS_cv}
\title{Compute Factor Match Score for two models.}
\usage{
FMS_cv(Fac1, Fac2, sharedMode = 1)
}
\arguments{
\item{Fac1}{A list of matrices corresponding to found components per mode in model 1.}

\item{Fac2}{A list of matrices corresponding to found components per mode in model 2.}

\item{sharedMode}{The shared mode that is excluded from FMS calculation.}
}
\value{
Scalar of FMS value
}
\description{
Compute Factor Match Score for two models.
}
\examples{
set.seed(123)

I = 10
J = 5
K = 3
df = array(rnorm(I*J*K), c(I,J,K))
datasets = list(df, df)
modes = list(c(1,2,3), c(1,4,5))
Z = setupCMTFdata(datasets, modes)

model1 = acmtf_opt(Z, 1)

Fac1 = model1$Fac[1:3]
Fac2 = Fac1 # identical models for the purposes of demonstration
result = FMS_cv(Fac1, Fac2) # [1] 1
}
