% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{n_dist2targ}
\alias{n_dist2targ}
\title{Normalise as distance to target}
\usage{
n_dist2targ(x, targ, direction = 1, cap_max = FALSE)
}
\arguments{
\item{x}{A numeric vector}

\item{targ}{An target value}

\item{direction}{Either 1 (default) or -1. In the former case, the indicator is assumed to be "positive" so that the target is at the higher
end of the range. In the latter, the indicator is "negative" so that the target is typically at the low end of the range.}

\item{cap_max}{If \code{TRUE}, any value of \code{x} that exceeds \code{targ} will be assigned a score of 1, otherwise
will have a score greater than 1.}
}
\value{
Numeric vector
}
\description{
A measure of the distance of each value of \code{x} to a specified target which can be a high or low target depending on \code{direction}. See details below.
}
\details{
If \code{direction = 1}, the formula is:

\deqn{ \frac{x - x_{min}}{x_{targ} - x_{min}} }

else if \code{direction = -1}:

\deqn{ \frac{x_{max} - x}{x_{max} - x_{targ}} }

Values surpassing \code{x_targ} in either case can be optionally capped at 1 if \code{cap_max = TRUE}.

This function also supports parameter specification in \code{iMeta} for the \code{\link[=Normalise.coin]{Normalise.coin()}} method.
To do this, add columns \code{Target}, and \code{dist2targ_cap_max} to the \code{iMeta} table, which correspond
to the \code{targ} and \code{cap_max} parameters respectively. Then set \code{f_n_para = "use_iMeta"} within the
\code{global_specs} list. See also examples in the \href{https://bluefoxr.github.io/COINr/articles/normalise.html}{normalisation vignette}.
}
\examples{
x <- runif(20)
n_dist2targ(x, 0.8, cap_max = TRUE)

}
