% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_beta_f.R
\name{q_beta_f}
\alias{q_beta_f}
\title{M-Step Expected Log-Likelihood with respect to Beta}
\usage{
q_beta_f(beta, X, w_mat, sample_size, n_cat)
}
\arguments{
\item{beta}{A numeric vector of regression parameters for the
\code{Y} (true outcome) ~ \code{X} (predictor matrix of interest).}

\item{X}{A numeric design matrix.}

\item{w_mat}{Matrix of E-step weights obtained from \code{w_j}.}

\item{sample_size}{An integer value specifying the number of observations in the sample.
This value should be equal to the number of rows of the design matrix, \code{X}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{Y},
can take.}
}
\value{
\code{q_beta_f} returns the negative value of the expected log-likelihood function,
\eqn{ Q_\beta = \sum_{i = 1}^N \Bigl[ \sum_{j = 1}^2 w_{ij} \text{log} \{ \pi_{ij} \}\Bigr]},
at the provided inputs.
}
\description{
Objective function of the form:
\eqn{ Q_\beta = \sum_{i = 1}^N \Bigl[ \sum_{j = 0}^1 w_{ij} \text{log} \{ \pi_{ij} \}\Bigr]}.
Used to obtain estimates of \eqn{\beta} parameters.
}
