% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmp.R
\name{CMP Distribution}
\alias{CMP Distribution}
\alias{dcmp}
\alias{rcmp}
\alias{pcmp}
\alias{qcmp}
\alias{ecmp}
\alias{vcmp}
\alias{ncmp}
\alias{tcmp}
\title{COM-Poisson Distribution}
\usage{
dcmp(x, lambda, nu, log = FALSE, control = NULL)

rcmp(n, lambda, nu, control = NULL)

pcmp(x, lambda, nu, control = NULL)

qcmp(q, lambda, nu, log.p = FALSE, control = NULL)

ecmp(lambda, nu, control = NULL)

vcmp(lambda, nu, control = NULL)

ncmp(lambda, nu, log = FALSE, control = NULL)

tcmp(lambda, nu, control = NULL)
}
\arguments{
\item{x}{vector of quantiles.}

\item{lambda}{rate parameter.}

\item{nu}{dispersion parameter.}

\item{log}{logical; if TRUE, probabilities are returned on log-scale.}

\item{control}{a \code{COMPoissonReg.control} object from \code{get.control}
or \code{NULL} to use global default.}

\item{n}{number of observations.}

\item{q}{vector of probabilities.}

\item{log.p}{logical; if TRUE, probabilities \code{p} are given as \eqn{\log(p)}.}
}
\value{
\describe{
\item{dcmp}{density,}
\item{pcmp}{cumulative probability,}
\item{qcmp}{quantiles,}
\item{rcmp}{generate random variates,}
\item{ecmp}{expected value,}
\item{vcmp}{variance,}
\item{ncmp}{value of the normalizing constant, and}
\item{tcmp}{upper value used to compute the normalizing constant under
truncation method.}
}
}
\description{
Functions for the COM-Poisson distribution.
}
\references{
Kimberly F. Sellers & Galit Shmueli (2010). A Flexible Regression Model for
Count Data. Annals of Applied Statistics, 4(2), 943-961.
}
\author{
Kimberly Sellers
}
\keyword{COM-Poisson}
\keyword{distribution}
