% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CREDS.R
\name{RCRatio}
\alias{RCRatio}
\title{Calibrated Ratio Estimator under Double Sampling Design}
\usage{
RCRatio(N, FSU, SSU)
}
\arguments{
\item{N}{Population size}

\item{FSU}{First stage sampling units}

\item{SSU}{Second stage sampling units}
}
\value{
\itemize{
  \item CalEstimate: Estimate value of calibration estimator
  \item CalVariance: Variance of calibration estimator
  \item CV: Coefficient of variance
  \item SampleSize: Sample Size of FSU and SSU
  \item DesignWeight: Design weight vector
  \item InclusionProb: Inclusion probability vector
  \item Correlation: Correlation value
}
}
\description{
Population ratio estimator under two-phase random sampling design has gained enormous popularity in present era. This package provides functions for estimation calibrated population ratio under two phase sampling design, including the approximate variance of the ratio estimator. The improved ratio estimator can be applicable for both the case, when auxiliary data is available at unit level or aggregate level for first phase sampled. Calibration weight of each unit of the second phase sample was calculated. Single and combined inclusion probabilities were also estimated for both phases under two phase random sampling. The improved ratio estimator's percentage coefficient of variation was also determined as a measure of accuracy.
}
\examples{
f1<-rnorm(100,20,5)
f2<-rnorm(100,20,5)
fsu<-cbind(f1,f2)
s1<-rnorm(50,20,5)
s2<-rnorm(50,20,5)
s3<-rnorm(50,20,5)
s4<-rnorm(50,20,5)
ssu<-cbind(s1,s2,s3,s4)
RCRatio(N=1000, FSU=fsu, SSU=ssu)

}
\references{
\itemize{
\item Islam, S., Chandra, H., Sud, U.C., Basak, P., Ghosh, N. and Ojasvi, P.R. (2021). A Revised Calibration Weight based Ratio Estimator in Two-phase Sampling: A Case when Unit Level Auxiliary Information is Available for the First-phase Sample, Journal of Indian Society of Agricultural Statistics, 75(2), 147–156.
\item Ozgul, N. (2021). New improved calibration estimator based on two auxiliary variables in stratified two-phase sampling. Journal of Statistical Computation and Simulation, 91(6), 1243-1256.
}
}
