% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu.data.R
\name{simu.data}
\alias{simu.data}
\title{Simulate data}
\usage{
simu.data(n.germline = 10000, segment.length = 100, seed = NULL, pc,
  read = 100, ps, dis = "Normal", parameter = NULL)
}
\arguments{
\item{n.germline}{is number with the total number of generating data which contains non-CNAs and non-SNVs. The default is 10000.}

\item{segment.length}{is number with the number of loci of every segment and the number is common divisor of n.germline. The default is 100.}

\item{seed}{is number that you can reproduce the simulation result and default is NULL.}

\item{pc}{is vector with the proportion of CNAs mutation of every segment.}

\item{read}{is number with the standard total read depth.}

\item{ps}{is vector with the proportion of SNVs mutation.}

\item{dis}{is distribution with generating the data and the default is Normal distribution. We provide Poisson and Negative binomial distribution to choose.}

\item{parameter}{is number and default is NULL. If dis is Normal and parameter is not NULL, then the standard deviation is parameter x mean. If dis is Normal and parameter is NULL, then the standard deviation is mean. If dis is Negative binomial and parameter is NULL, then the parameter is second parameter. If dis is Negative binomial and parameter NULL, then the second parameter is 0.5.}
}
\value{
y is n x 2 matrix. The first column is the B allele read depth and the second column is the total read depth.

snv.id is vector which denotes which loci with SNVs mutation.

cnt.id is A x B matrix which denotes which loci with CNAs mutation.. The A is segment.length and the B is the number of segment with CNAs mutation.

cnv is n x 4 matrix. The first column is the total copy number after CNAs mutation, the second column is the cnb1, the third column is the cnb2, and the fourth column is the proportion of CNAs mutation. The cnb1 and the cnb2 has detailed explanation at l.s function.
}
\description{
simu.data is generating the data which simulates the locus.
}
\details{
The simu.data can consider not only SNVs mutation but also CNAs mutation and generate the data which contains germline data and mutation data.
}
\author{
Peter Wu (peter123wu0@gmail.com)
}

