% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotImageProfile.R
\name{plotImageProfile}
\alias{plotImageProfile}
\title{Plot scan image, profile path and ring limits}
\usage{
plotImageProfile(densProfile, im)
}
\arguments{
\item{densProfile}{Density profile}

\item{im}{Density matrix}
}
\value{
Plot
}
\description{
Plot scan image, profile path and ring limits
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
im_dens <- grayToDensity(im_8bit)

pith_coord <- detect_pith(im_dens, n_segments = 12, pixel = TRUE, toPlot = FALSE)

endPath <- c(472, 284) # manual

path <- extractProfile(im_dens, image_info, pith_coord, endPath, k = 2, r = 5, threshold = 0.002)

plotProfile(path)

plotImageProfile(path, im_dens)

}
