% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeLastYear.R
\name{removeLastYear}
\alias{removeLastYear}
\title{Remove the last year of a profile}
\usage{
removeLastYear(densProfile)
}
\arguments{
\item{densProfile}{Density profile}
}
\value{
Density profile with the last year removed
}
\description{
Remove the last year of a profile
}
\examples{

library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
im_dens <- grayToDensity(im_8bit)

pith_coord <- detect_pith(im_dens, n_segments = 12, pixel = TRUE, toPlot = FALSE)

endPath <- c(472, 284) # manual
# not run - endPath <- locatePathEnd(im_dens, pith_coord) # using the image

path <- extractProfile(im_dens, image_info, pith_coord, endPath, k = 2, r = 5, threshold = 0.002)
path_last_year_2021 <- addYears(2021, path)
path_last_year_2020 <- removeLastYear(path_last_year_2021)
}
