% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cub0q.R
\name{cub0q}
\alias{cub0q}
\title{Main function for CUB models with covariates for the feeling component}
\usage{
cub0q(m, ordinal, W, maxiter, toler)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{W}{Matrix of selected covariates for explaining the feeling component, not including intercept}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}
}
\value{
An object of the class "CUB"
}
\description{
Function to estimate and validate a CUB model for given ordinal responses, with covariates for
explaining the feeling component.
}
\references{
Piccolo D. and D'Elia A. (2008), A new approach for modelling consumers' preferences,
\emph{Food Quality and Preference}, \bold{18}, 247--259 \cr

Iannario M. and Piccolo D. (2010), A new statistical model for the analysis of customer
satisfaction, #' \emph{Quality Technology and Quantity management}, \bold{7}(2) 149--168 \cr
Iannario M. and Piccolo D. (2012), CUB models: Statistical methods and empirical evidence, in:
Kenett R. S. and Salini S. (eds.), \emph{Modern Analysis of Customer Surveys: with applications using R},
J. Wiley and Sons, Chichester, 231--258.
}
\keyword{internal}
