\name{Efficacy}
\alias{Efficacy}

\title{
Estimate the efficacy of a biomarker
}
\description{
The efficacy of a biomarker is defined by the treatment saved below a cut-off point minus the missclasified events.
}
\usage{Efficacy(Prob,yt,z)
}

\arguments{
  \item{Prob}{A vector with the event probability values provided by the biomarker
}
\item{yt}{A vector with the actual event values
}
\item{z}{The misclassification rate at which the effectiveness of the marker will be estimated.
}
}
\details{
Prob must be a numeric vector with values between 0 and 1, yt  a numeric vector with dichotomic values 0/1 and z a numeric value between 0 and 100
}
\value{
The returned object contains the Efficacy of the biomarker Prob at a specific z rate of missclasified events
\item{Efficacy}{Efficacy of the biomarker Prob at a specific z rate of missclasified events}
}


\author{Maria Escorihuela, Luis Mariano Esteban, Gerardo Sanz, Angel Borque
}

\examples{
###We generate a marker to serve as an example

Prob<-c(rnorm(10000,0.4,0.1),rnorm(10000,0.5,0.05))
yt<-rep(c(0,1),c(10000,10000))
#We choose a rate of 10\% for misclassified events.
Efficacy(Prob=Prob,yt=yt,z=10)
}
\keyword{misc}
\keyword{clinical utility}
