% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affine.R
\docType{class}
\name{Kron-class}
\alias{Kron-class}
\alias{.Kron}
\alias{Kron}
\alias{to_numeric,Kron-method}
\alias{validate_args,Kron-method}
\alias{dim_from_args,Kron-method}
\alias{sign_from_args,Kron-method}
\alias{is_incr,Kron-method}
\alias{is_decr,Kron-method}
\alias{graph_implementation,Kron-method}
\title{The Kron class.}
\usage{
Kron(lh_exp, rh_exp)

\S4method{to_numeric}{Kron}(object, values)

\S4method{validate_args}{Kron}(object)

\S4method{dim_from_args}{Kron}(object)

\S4method{sign_from_args}{Kron}(object)

\S4method{is_incr}{Kron}(object, idx)

\S4method{is_decr}{Kron}(object, idx)

\S4method{graph_implementation}{Kron}(object, arg_objs, dim, data = NA_real_)
}
\arguments{
\item{lh_exp}{An \linkS4class{Expression} or numeric constant representing the left-hand matrix.}

\item{rh_exp}{An \linkS4class{Expression} or numeric constant representing the right-hand matrix.}

\item{object}{A \linkS4class{Kron} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{dim}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the kronecker product.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric(Kron)}: The kronecker product of the two values.

\item \code{validate_args(Kron)}: Check both arguments are vectors and the first is a constant.

\item \code{dim_from_args(Kron)}: The dimensions of the atom.

\item \code{sign_from_args(Kron)}: The sign of the atom.

\item \code{is_incr(Kron)}: Is the left-hand expression positive?

\item \code{is_decr(Kron)}: Is the right-hand expression negative?

\item \code{graph_implementation(Kron)}: The graph implementation of the atom.

}}
\section{Slots}{

\describe{
\item{\code{lh_exp}}{An \linkS4class{Expression} or numeric constant representing the left-hand matrix.}

\item{\code{rh_exp}}{An \linkS4class{Expression} or numeric constant representing the right-hand matrix.}
}}

