% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Log_Gumbel_Formula.R
\name{Log_Gumbel_Formula}
\alias{Log_Gumbel_Formula}
\title{Log Gumbel CDF Equation Formula}
\usage{
Log_Gumbel_Formula(concentration, shape_location, scale)
}
\arguments{
\item{concentration}{The vector of concentration values for a selected pesticide,
that has a Log Gumbel shaped species sensitivity distribution,
to run the equation on.}

\item{shape_location}{The mu/location value for the Log Gumbel equation for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}

\item{scale}{The beta/scale value for the Log Gumbel equation for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}
}
\value{
a numeric vector
}
\description{
Log Gumbel CDF Equation Formula
}
\examples{
#This Example should produce roughly 1\% and 5\% PRM values
LogGumbel_pesticide_concentrations <- c(0.095957794, 0.245881898)
Log_Gumbel_Formula(concentration = LogGumbel_pesticide_concentrations,
shape_location = 0.9980581, scale = 2.188285)
}
