% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconnect_pyDarwinJob.R
\name{reconnect_pyDarwinJob}
\alias{reconnect_pyDarwinJob}
\title{Reconnect, Monitor, and Retrieve Results from a Remote pyDarwin Job}
\usage{
reconnect_pyDarwinJob(
  LocalDirectoryPath = ".",
  LocalJobInfoFilePath = NULL,
  OriginalOptionsPath = NULL,
  Password = NULL,
  KeyPath = NULL,
  MonitoringInterval = 30,
  verbose = getOption("verbose", default = FALSE)
)
}
\arguments{
\item{LocalDirectoryPath}{Character string: The base local directory associated
with the pyDarwin job. This directory is used to:
1. Locate the job information file (if \code{LocalJobInfoFilePath} is NULL),
expected as \verb{\{ProjectName\}_remote_job_info.json}.
2. Locate the original \code{options.json} file (if \code{OriginalOptionsPath} is NULL).
3. Serve as the base location for downloading results into a subdirectory
(e.g., \verb{\{LocalDirectoryPath\}/\{ProjectName\}_Results/}).}

\item{LocalJobInfoFilePath}{Character string (optional): Explicit path to the local
JSON file containing information about the remote job (e.g., as created by
\code{RunPyDarwinRemote(Wait = FALSE)}). If NULL (default), the path is constructed
using \code{LocalDirectoryPath} and \code{ProjectName} (derived from \code{OriginalOptionsPath}).}

\item{OriginalOptionsPath}{Character string (optional): Explicit path to the original
local \code{options.json} file that was used when the job was first launched.
This is needed to correctly parse results (e.g., \code{engine_adapter}) and
to derive \code{ProjectName} if not available from \code{LocalJobInfoFilePath}.
If NULL (default), the function attempts to find \code{options.json} within
\code{LocalDirectoryPath}. If not found, the operation will stop.}

\item{Password}{Character string. The password for SSH authentication. Defaults
to \code{""}, which is appropriate when using key-based authentication. Using
keys is strongly recommended over embedding passwords in scripts.}

\item{KeyPath}{Character string. The path to your private SSH key file.
Defaults to the path stored in the \code{SSH_PRIVATE_KEY_PATH} environment variable.}

\item{MonitoringInterval}{Numeric. The interval in seconds between status
checks when monitoring a running job (\code{Wait = TRUE}).}

\item{verbose}{Logical: Passed to helper functions for verbose output during
SSH connection and file downloads.
Default: \code{getOption("verbose", default = FALSE)}.}
}
\value{
A list containing parsed results similar to \code{RunPyDarwinRemote(Wait = TRUE)}
(i.e., \code{results} data.frame, \code{FinalResultFile}, \code{FinalControlFile},
\code{DownloadedResultsDir}, \code{DownloadedItems}), or the content of the
downloaded \code{messages.txt} as a character vector if primary result
files are not found or parsed successfully. If essential information
(like job info or options file) is missing, the function will stop.
}
\description{
This function reconnects to a pyDarwin job previously launched in the background
on a remote host. It monitors the job until completion (if a PID is available),
then downloads and processes the results.
}
\details{
This function requires a job information JSON file (typically created by
\code{RunPyDarwinRemote} when \code{Wait = FALSE}) to obtain details like the remote host,
user, remote project directory, and optionally the remote process ID (PID).

The \code{ProjectName} is crucial. It's primarily derived from the \code{project_name}
field in the original options file (located via \code{OriginalOptionsPath} or within
\code{LocalDirectoryPath}). If not present in the options file, a fallback derivation
uses the parent directory name of the options file. This \code{ProjectName} is then
used to find the job info file (as \verb{\{ProjectName\}_remote_job_info.json} in
\code{LocalDirectoryPath}) if \code{LocalJobInfoFilePath} is not directly provided.
If the job info file itself contains a \code{ProjectName}, that value may take precedence.
Downloaded results are organized locally using this determined \code{ProjectName}.

If \code{RemoteJobPID} is available in the job info file, the function will actively
monitor the process. If the PID is not available, it will skip active monitoring
and proceed directly to attempt downloading any available results.
}
\examples{
\dontrun{
# Assuming 'my_project_job_info.json' and 'options.json' exist in '~/darwin_runs/my_project_run'
# and 'my_project_job_info.json' was created by a previous RunPyDarwinRemote(Wait=FALSE) call.

# Example 1: Specifying only the local directory path
# ProjectName will be derived from options.json within that path.
# Job info file will be sought as {ProjectName}_remote_job_info.json.
try({
  reconnect_pyDarwinJob(
    LocalDirectoryPath = "~/darwin_runs/my_project_run"
  )
})

# Example 2: Specifying paths explicitly
try({
  reconnect_pyDarwinJob(
    LocalDirectoryPath = "~/darwin_runs/my_project_run", # Still used for downloads
    LocalJobInfoFilePath = "~/darwin_runs/my_project_run/my_project_remote_job_info.json",
    OriginalOptionsPath = "~/darwin_runs/my_project_run/options.json",
    KeyPath = "~/.ssh/id_rsa_remote_server"
  )
})
}


}
\seealso{
\code{\link[=run_pyDarwin]{run_pyDarwin()}}, \code{\link[=run_pyDarwinRemote]{run_pyDarwinRemote()}}
}
