% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkmodel.R
\name{pkmodel_MappingParameters}
\alias{pkmodel_MappingParameters}
\title{PK model mapping parameters}
\usage{
pkmodel_MappingParameters(
  ID = NULL,
  Time = NULL,
  A1 = NULL,
  Aa = NULL,
  A = NULL,
  A1_Rate = NULL,
  A1_Duration = NULL,
  Aa_Rate = NULL,
  Aa_Duration = NULL,
  A_Rate = NULL,
  A_Duration = NULL,
  A1Strip = NULL,
  CObs = NULL,
  C1Obs = NULL,
  A0Obs = NULL
)
}
\arguments{
\item{ID}{Column mapping argument for input dataset column(s) that identify
individual data profiles. Only applicable to population models \code{isPopulation = TRUE}.}

\item{Time}{Column mapping argument that represents the input dataset column
for the relative time used in a study and only applicable to time-based models.}

\item{A1}{Column mapping argument that represents the input dataset column
for the amount of drug administered. Only applicable to the following types of models:
\itemize{
 \item Models with \code{absorption = "Intravenous"} and parameterization set
 to either \code{"Clearance"},\code{"Micro"}, or \code{"Macro"}
 \item Models with \code{absorption} set to either \code{"Gamma"},
 \code{"InverseGaussian"}, or \code{"Weibull"}
 }}

\item{Aa}{Column mapping argument that represents the input dataset column
for the amount of drug administered and only applicable to models with \code{absorption = "FirstOrder"}.}

\item{A}{Column mapping argument that represents the input dataset column
for the amount of drug administered and only applicable to models with
\code{absorption = "Intravenous"} and \code{parameterization = "Macro1"}.}

\item{A1_Rate}{Column mapping argument that represents the input dataset column
for the rate of drug administered.  Only applicable to the following types of models:
\itemize{
 \item Models with \code{absorption = "Intravenous"}, \code{infusionAllowed = TRUE}
  and parameterization set to either \code{"Clearance"},\code{"Micro"} or \code{"Macro"}
 \item Models with \code{absorption} set to either \code{"Gamma"}, \code{"InverseGaussian"},
  or \code{"Weibull"} and \code{infusionAllowed = TRUE}
  }}

\item{A1_Duration}{Column mapping argument that represents the input dataset column
for the duration of drug administered.  Only applicable to the following types of models:
\itemize{
 \item Models with \code{absorption = "Intravenous"},\code{infusionAllowed = TRUE}
  with \code{isDuration = TRUE} and parameterization set to either \code{"Clearance"},
  \code{"Micro"} or \code{"Macro"}
 \item Models with \code{absorption} set to either \code{"Gamma"}, \code{"InverseGaussian"},
  or \code{"Weibull"} and \code{infusionAllowed = TRUE} with \code{isDuration = TRUE}
  }}

\item{Aa_Rate}{Column mapping argument that represents the input dataset column
for the rate of drug administered and only applicable to models with \code{absorption = "FirstOrder"},
\code{infusionAllowed = TRUE}.}

\item{Aa_Duration}{Column mapping argument that represents the input dataset column
for the duration of drug administered and only applicable to models with \code{absorption = "FirstOrder"},
 \code{infusionAllowed = TRUE}, and \code{isDuration = TRUE}.}

\item{A_Rate}{Column mapping argument that represents the input dataset column
for the rate of drug administered and only applicable to models with \code{absorption = "Intravenous"},
\code{infusionAllowed = TRUE}, and \code{parameterization = "Macro1"}.}

\item{A_Duration}{Column mapping argument that represents the input dataset column
for the duration of drug administered and only applicable to models with \code{absorption = "Intravenous"},
\code{infusionAllowed = TRUE}, \code{isDuration = TRUE}, and \code{parameterization = "Macro1"}.}

\item{A1Strip}{Column mapping argument that represents the input dataset column
for the stripping dose and only applicable to models with \code{parameterization = "Macro"}.}

\item{CObs}{Column mapping argument that represents the input dataset column
for the observations of drug concentration in the central compartment and only applicable
to models with \code{parameterization} being either set to either \code{"Clearance"} or \code{"Micro"}.}

\item{C1Obs}{Column mapping argument that represents the input dataset column
for the observations of drug concentration in the central compartment and only applicable
to models with \code{parameterization} being either set to either \code{"Macro"} or \code{"Macro1"}.}

\item{A0Obs}{Column mapping argument that represents the input dataset column
for the observed amount of drug in the elimination compartment. (\code{hasEliminationComp = TRUE}).}
}
\description{
PK model mapping parameters
}
\section{Column mapping}{

Note that quoted and unquoted column names are supported. Please see \code{\link{colMapping}}.
}

\keyword{internal}
