test_that("xpose used for convergence  ", {
  workingDir <- system.file("extdata/prm_iteration",
    package = "Certara.Xpose.NLME",
    mustWork = TRUE
  )
  modelName <- "OneCpt_Parallel1stOrderAbsorp"
  dmp.json <- paste0(modelName, "_dmp.json")
  dmp.txt <- jsonlite::fromJSON(readLines(file.path(workingDir, dmp.json)))

  residuals.csv <- paste0(modelName, "_residuals.csv")
  dmp.txt$residuals <- utils::read.csv(file.path(workingDir, residuals.csv))

  dataFile <- paste0(modelName, ".csv")

  logFile <- paste0(modelName, "_nlme7engine.log")

  ConvergenceDatacsv <- file.path(workingDir, paste0(modelName, "_ConvergenceData.csv"))
  ConvergenceData <- utils::read.csv(ConvergenceDatacsv)
  # turn off locale-specific sorting
  Sys.setlocale("LC_COLLATE", "C")
  xpdb <- xposeNlme(
    dir = workingDir,
    dmp.txt = dmp.txt,
    dataFile = dataFile,
    logFile = logFile,
    ConvergenceData = ConvergenceData
  )

  Convresults <- as.data.frame(xpdb$files$data[[1]])
  Summaryresults <- as.data.frame(xpdb$summary)
  # removing dir
  Summaryresults$value[Summaryresults$label == "dir"] <- ""

  testthat::local_edition(3)
  testthat::expect_snapshot(Convresults)
  testthat::expect_snapshot(Summaryresults)
})
