% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dcddm}
\alias{dcddm}
\alias{rcddm}
\title{The Circular Drift-diffusion Distribution}
\usage{
dcddm(x, pVec, k = 141L)

rcddm(n, pVec, p = 0.15)
}
\arguments{
\item{x}{a matrix storing a first column as RT and a second column of
continuous responses/reports/outcomes. Each row is a trial.}

\item{pVec}{a parameter vector with the order [a, vx, vy, t0, s],
or [thresh, mu1, mu2, ndt, sigmasq]. The order matters.}

\item{k}{a precision for calculating the infinite series in \code{dcddm}. The
larger the k is, the larger the memory space is required. Default is 141.}

\item{n}{number of observations.}

\item{p}{a precision for random walk step in \code{rcddm}. Default is 0.15
second}
}
\value{
\code{dcddm} gives a log-likelihood vector. \code{rddm} generates
random deviates, returning a n x 3 matrix with the columns: RTs, choices
and then angles.
}
\description{
Density function and random generation for the circular drift-diffusion
model with theta vector equal to \code{pVec}.  \code{dcddm} is the
equation (23) on page 433 in Smith (2016).
}
\examples{
## dcddm example
x <- cbind(
RT= c(1.2595272, 0.8693937, 0.8009044, 1.0018933, 2.3640007, 1.0521304),
R = c(1.9217430, 1.7844653, 0.2662521, 2.1569724, 1.7277440, 0.8607271)
)
pVec <- c(a=2.45, vx=1.5, vy=1.25, t0=.1, s=1)
dcddm(x, pVec)

## rcddm example
pVec <- c(a=2, vx=1.5, vy=1.25, t0=.25, s=1)
den  <- rcddm(1e3, pVec);
hist(den[,1], breaks = "fd", xlab="Response Time",  main="Density")
hist(den[,3], breaks = "fd", xlab="Response Angle", main="Density")
}
\references{
Smith, P. L. (2016). Diffusion Theory of Decision Making in
Continuous Report, Psychological Review, 123 (4), 425--451.
}
