% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_gmax.r
\name{calculate_gmax}
\alias{calculate_gmax}
\title{Calculate the maximum possible tree length, gmax, under parsimony}
\usage{
calculate_gmax(costmatrix, n_taxa, allow_zeroes = FALSE)
}
\arguments{
\item{costmatrix}{An object of class \code{costMatrix}.}

\item{n_taxa}{The number of taxa (ree tips) to consider.}

\item{allow_zeroes}{Logical indicating whether some states are allowed to be assigned zero tips. Defaults to \code{FALSE} (recommended). Note that if the number of states exceeds the number of tips then \code{allow_zeroes = TRUE} is forced.}
}
\value{
A numeric indicating the maximum possible cost, \emph{gmax}.
}
\description{
Given a costmatrix and number of tips, calculates the longest possible tree length under maximum parsimony.
}
\details{
The concept of \emph{gmax} was introduced by Hoyal Cuthill et al. (2010) and in the strictest sense represents the integer state frequency that maximizes \emph{g} with the restriction that every state is sampled at least once. This function is intended to relax that slightly using the \code{allow_zeroes} option and indeed this is not possible in rare cases such as either high levels of missing data or gap-weighted (Thiele 1993) characters where it is possible for the number of states to exceed the (effective) number of tips. For a more detailed description of the problem and implemented solution(s) see Hoyal Cuthill and Lloyd (in press).
}
\examples{

# Create a Type I character costmatrix:
constant_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 0,
  character_type = "unordered"
)

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = constant_costmatrix,
  n_taxa = 10
)

# Create a Type II character costmatrix:
binary_symmetric_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 1,
  character_type = "unordered"
)

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = binary_symmetric_costmatrix,
  n_taxa = 10
)

# Create a Type III character costmatrix:
unordered_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 2,
  character_type = "unordered"
)

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = unordered_costmatrix,
  n_taxa = 10
)

# Create a Type IV character costmatrix:
linear_ordered_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 2,
  character_type = "ordered"
)

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = linear_ordered_costmatrix,
  n_taxa = 10
)

# Create a Type V character costmatrix:
nonlinear_ordered_costmatrix <- convert_adjacency_matrix_to_costmatrix(
  adjacency_matrix = matrix(
    data = c(
      0, 1, 0, 0,
      1, 0, 1, 1,
      0, 1, 0, 0,
      0, 1, 0, 0
    ),
    nrow = 4,
    dimnames = list(0:3, 0:3)
  )
)

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = nonlinear_ordered_costmatrix,
  n_taxa = 10
)


# Create a Type VI character costmatrix:
binary_irreversible_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 1,
  character_type = "irreversible"
)

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = binary_irreversible_costmatrix,
  n_taxa = 10
)

# Create a Type VII character costmatrix:
multistate_irreversible_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 2,
  character_type = "irreversible"
)

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = multistate_irreversible_costmatrix,
  n_taxa = 10
)

#' # Create a Type VIII character costmatrix:
binary_dollo_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 1,
  character_type = "dollo"
)

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = binary_dollo_costmatrix,
  n_taxa = 10
)

# Create a Type IX character costmatrix:
multistate_dollo_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 2,
  character_type = "dollo"
)

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = multistate_dollo_costmatrix,
  n_taxa = 10
)

# Create a Type X character costmatrix:
multistate_symmetric_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 5,
  character_type = "ordered"
)
multistate_symmetric_costmatrix$type <- "custom"
multistate_symmetric_costmatrix$costmatrix <- matrix(
  data = c(
    0, 1, 2, 3, 2, 3,
    1, 0, 3, 2, 1, 2,
    2, 3, 0, 3, 2, 1,
    3, 2, 3, 0, 1, 2,
    2, 1, 2, 1, 0, 1,
    3, 2, 1, 2, 1, 0
  ),
  nrow = multistate_symmetric_costmatrix$size,
  ncol = multistate_symmetric_costmatrix$size,
  byrow = TRUE,
  dimnames = list(
    multistate_symmetric_costmatrix$single_states,
    multistate_symmetric_costmatrix$single_states
  )
)

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = multistate_symmetric_costmatrix,
  n_taxa = 10
)

# Create a Type XI character costmatrix:
binary_asymmetric_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 1,
  character_type = "ordered"
)
binary_asymmetric_costmatrix$type <- "custom"
binary_asymmetric_costmatrix$costmatrix <- matrix(
  data = c(
    0, 1,
    10, 0
  ),
  nrow = binary_asymmetric_costmatrix$size,
  ncol = binary_asymmetric_costmatrix$size,
  byrow = TRUE,
  dimnames = list(
    binary_asymmetric_costmatrix$single_states,
    binary_asymmetric_costmatrix$single_states
  )
)
binary_asymmetric_costmatrix$symmetry <- "Asymmetric"

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = binary_asymmetric_costmatrix,
  n_taxa = 10
)

# Create a Type XII character costmatrix:
multistate_asymmetric_costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 2,
  character_type = "ordered"
)
multistate_asymmetric_costmatrix$type <- "custom"
multistate_asymmetric_costmatrix$costmatrix <- matrix(
  data = c(
    0, 1, 1,
    1, 0, 1,
    10, 10, 0
  ),
  nrow = multistate_asymmetric_costmatrix$size,
  ncol = multistate_asymmetric_costmatrix$size,
  byrow = TRUE,
  dimnames = list(
    multistate_asymmetric_costmatrix$single_states,
    multistate_asymmetric_costmatrix$single_states
  )
)
multistate_asymmetric_costmatrix$symmetry <- "Asymmetric"

# Calculate gmax for ten tips:
calculate_gmax(
  costmatrix = multistate_asymmetric_costmatrix,
  n_taxa = 10
)

}
\references{
Hoyal Cuthill, J. F. and Lloyd, G. T., in press. Measuring homoplasy I: comprehensive measures of maximum and minimum cost under parsimony across discrete cost matrix character types. \emph{Cladistics}, bold{}, .

Hoyal Cuthill, J. F., Braddy, S. J. and Donoghue, P. C. J., 2010. A formula for maximum possible steps in multistate characters: isolating matrix parameter effects on measures of evolutionary convergence. \emph{Cladistics}, \bold{26}, 98-102.

Thiele, K.. 1993. The Holy Grail of the perfect character: the cladistic treatment of morphometric data. \emph{Cladistics}, \bold{9}, 275-304.
}
\seealso{
\link{calculate_g}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com} and Jen Hoyal Cuthill \email{j.hoyal-cuthill@essex.ac.uk}
}
