% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathawards3.R
\name{pathawards3}
\alias{pathawards3}
\title{The path of awards for three claimants}
\usage{
pathawards3(d, claimants, Rule, col = "red", points = 300)
}
\arguments{
\item{d}{The vector of claims.}

\item{claimants}{Three claimants.}

\item{Rule}{The rule: AA, APRO, CE, CEA, CEL, AV, DT, MO, PIN, PRO, RA, Talmud, RTalmud.}

\item{col}{The colour of the path, by default, col="red".}

\item{points}{The number of values of the endowment to draw the path.}
}
\value{
The graphical representation of the path of awards of a rule for the given claims and three claimants.
}
\description{
This function returns the graphical representation of the path of awards of any rule for a claims vector and three claimants.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{d\in \mathbb{R}_+^N} a vector of claims and
 denote by \eqn{D=\sum_{i \in N} d_i} the sum of claims.

The path of awards of a rule \eqn{\mathcal{R}} for three claimants \eqn{i,j,k\in N} is the parametric curve:
\deqn{p(E)=\Bigl\{(\mathcal{R}_i(E,d),\mathcal{R}_j(E,d),\mathcal{R}_k(E,d))\in \mathbb{R}^3:\;E\in[0,D]\Bigr\}.}
}
\examples{
d=c(2,4,7,8)
claimants=c(1,3,4)
Rule=Talmud
pathawards3(d,claimants,Rule)
}
\seealso{
\link{pathawards}, \link{schedrule}, \link{schedrules}, \link{verticalruleplot}.
}
