% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{compare_doublets_exp_obs}
\alias{compare_doublets_exp_obs}
\title{Tabulate expected and observed proportions of doublet types.}
\usage{
compare_doublets_exp_obs(doublet_clas, singlet_clas, cleanet_res)
}
\arguments{
\item{doublet_clas}{An array giving a classification of the doublets, whose
length must match the number of doublet events returned in cleanet_res.}

\item{singlet_clas}{An array giving a classification of the singlets, whose
length must match the number of singlet events returned in cleanet_res.}

\item{cleanet_res}{The output of a call to the cleanet function.}
}
\value{
A data frame tabulating expected and observed proportions for
each unique doublet type.
}
\description{
Given compatible classifications of singlets and doublets,
this function computes expected proportions of doublets as the product
of the proportions of their components.
}
\examples{
path <- system.file("extdata", "df_mdipa.csv", package="Cleanet")
df_mdipa <- read.csv(path, check.names=FALSE)
cols <- c("CD45", "CD123", "CD19", "CD11c", "CD16",
          "CD56", "CD294", "CD14", "CD3", "CD20",
          "CD66b", "CD38", "HLA-DR", "CD45RA",
          "DNA1", "DNA2")
cleanet_res <- cleanet(df_mdipa, cols, cofactor=5)
singlet_clas <- df_mdipa$label[which(cleanet_res$status!="Doublet")]
doublet_clas <- classify_doublets(cleanet_res, singlet_clas)
df_exp_obs <- compare_doublets_exp_obs(doublet_clas, singlet_clas, cleanet_res)
}
