% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv03_usl_unification.R
\name{cv03_usl_unification}
\alias{cv03_usl_unification}
\title{Unify USL Percentages for Specified Residue}
\usage{
cv03_usl_unification(data, cleaning_event_col, residue_col, usl_col)
}
\arguments{
\item{data}{A dataframe containing the relevant dataset.}

\item{cleaning_event_col}{Name of the column in `data` that contains the cleaning event identifiers as a string.}

\item{residue_col}{Name of the column in `data` that contains the residue measurements as a string.}

\item{usl_col}{Name of the column in `data` that contains the USL values as a string.}
}
\value{
A dataframe with original data and additional columns for residue percentages, and their mean and median values per cleaning event and overall.
}
\description{
This function takes a dataset and computes the percentage of residue over USL for each event, as well as mean and median of these percentages for each cleaning event and overall.
}
\examples{
cv03_usl_unification(data = Eq_DAR, cleaning_event_col = "CleaningEvent", 
residue_col = "DAR", usl_col = "USL")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
