% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv09_kw_test.R
\name{cv09_kw_test}
\alias{cv09_kw_test}
\title{Kruskal-Wallis Test for Residue Percentages}
\usage{
cv09_kw_test(data, residue_col, cleaning_event_col)
}
\arguments{
\item{data}{A data frame containing the data.}

\item{residue_col}{The name of the column containing residue percentages.}

\item{cleaning_event_col}{The name of the column containing cleaning event identifiers.}
}
\value{
A data frame of Kruskal-Wallis test results.
}
\description{
Perform Kruskal-Wallis test for residue percentages based on cleaning events.
}
\examples{
# Assuming 'Eq_DAR' is the data frame, 'DAR_Pct' is the residue column, 
# and 'CleaningEvent' is the cleaning event column.
Eq_DAR <- cv01_dfclean(data=Eq_DAR, cleaning_event_col="CleaningEvent", 
residue_col="DAR", usl_col="USL" ) 
Eq_DAR <- cv03_usl_unification(data=Eq_DAR, cleaning_event_col="CleaningEvent", 
residue_col="DAR", usl_col="USL")
kw_test_results <- cv09_kw_test(data = Eq_DAR, residue_col = "DAR_Pct", 
 cleaning_event_col = "CleaningEvent")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
