% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv17_cusum.R
\name{cv17_cusum}
\alias{cv17_cusum}
\title{Create a CUSUM Chart for Poisson-distributed Data}
\usage{
cv17_cusum(data, residue_col, cleaning_event_col, k = NULL)
}
\arguments{
\item{data}{A data frame containing the dataset for analysis.}

\item{residue_col}{The name of the column representing residue data.}

\item{cleaning_event_col}{The name of the column representing cleaning events.}

\item{k}{The reference value used in calculating CUSUM, by default it is set to half of lambda.}
}
\value{
A ggplot object representing the CUSUM chart.
}
\description{
This function computes the cumulative sum (CUSUM) for the mean values of 
a specified residue column aggregated by a cleaning event column. It then 
generates a CUSUM chart for visualizing the stability of a process based on 
a Poisson distribution. The reference value `k` can be provided; if not,
it defaults to half of the process average lambda.
}
\examples{
# To create a CUSUM chart with default k value
cv17_cusum(data = Eq_Mic, residue_col = "Mic", cleaning_event_col = "CleaningEvent")

# To create a CUSUM chart with a specified k value
cv17_cusum(data = Eq_Mic, residue_col = "Mic", cleaning_event_col = "CleaningEvent", k = 0.75)
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
