% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{eto}
\alias{eto}
\title{Reference evapotranspiration}
\usage{
eto(
  tmin,
  tmax,
  toa,
  w,
  lat,
  tdew,
  mde,
  radiation = NA,
  insolation = NA,
  rh = NA,
  data_names = NULL,
  time.scale = YEAR,
  na.rm = FALSE
)
}
\arguments{
\item{tmin}{daily minimum temperature, Celsius}

\item{tmax}{daily maximum temperature, Celsius}

\item{toa}{solar radiation at TOA, W/m2}

\item{w}{average wind, m/s}

\item{lat}{latitude, degree}

\item{tdew}{dew point, Celsius}

\item{mde}{digital elevation model, m}

\item{radiation}{net radiation, J/m2}

\item{insolation}{insolation, hours of sun}

\item{rh}{relative humidity, percentage}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
mm
}
\description{
If data available using Fao-56 Penman-Monteith
}
\examples{
data(data_all)
eto(tmin = data_all$tn, tmax = data_all$tx, 
     toa = data_all$radiationtoa, w = data_all$wind,
     lat=data_all$lat, tdew = data_all$dewpoint, 
     mde=data_all$mde, radiation = data_all$radiation, 
     insolation=data_all$insolation, rh = data_all$humidity)
}
\references{
Chiew, F.H.S., Kamaladasa, N.N., Malano, H.M., McMahon, T.A., 1995. Penman–Monteith FAO-24 reference crop evapotranspiration and class-A pan data in Australia. Agric. Water Manage. 28, 9–21
}
