% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nesterovIndex.R
\name{nesterovIndex}
\alias{nesterovIndex}
\title{Nesterov Index}
\usage{
nesterovIndex(t, rh, p, modified = FALSE)
}
\arguments{
\item{t}{Temperature}

\item{rh}{Relative humidity}

\item{p}{Precipitation}

\item{modified}{Logical flag indicating wheter to use the classical index definition (default) or the modified version (see Details)}
}
\value{
A vector of (daily) NI data
}
\description{
Implementation of the Nesterov Index for fire danger estimation
}
\details{
The Nesterov Index (NI) was developed in former Soviet Union as an empirical function reflecting the relationship between observed weather
 conditions and fire occurrence, defined as follows:

\deqn{NI=\sum_{\forall p_i\leq 3mm}^i T_i(T_i-Td_i)}

  where \eqn{T} is midday temperature and \eqn{Td} is the dewpoint temperature at that moment, calculated from relative humidity and \eqn{T}.
   NI is a cumulative index, but summation is performed for those days when the daily precipitation (\eqn{p}) does not exceed 3 mm.
   At  \eqn{p >3 mm}, the NI value is reset to zero. Usually, the values from NI are divided into five ranges to provide an
    estimate of fire danger potential. Conditions with \eqn{NI<300} (regime I) are not considered hazardous. 
    Conditions in the ranges 300-1000, 1000-4000, 4000-10000, and  above 10000 are considered regimes with low (II), moderate (III), high (IV), 
   and extreme (V) level of fire hazard. 
     
 Previous studies reveal that NI may be unstable in some cases, and a modification on this index has been proposed by introducing
  to its values a \emph{K} scale coefficient, in the range 0-1, accounting for the amount of precipitation and previous dryness in a more detailed 
  way than the original NI equation. Details on the values of  \emph{K} are provided by Groisman \emph{et al.} 2007.
  @references 
  \itemize{
\item Groisman, P.Y., Sherstyukov, B.G., Razuvaev, V.N., Knight, R.W., Enloe, J.G., Stroumentova, N.S., Whitfield, P.H., Forland, E., Hannsen-Bauer, I., Tuomenvirta, H., Aleksandersson, H., Mescherskaya, A.V., Karl, T.R., 2007. Potential forest fire danger over Northern Eurasia: Changes during the 20th century. Global and Planetary Change 56, 371–386. 
\item Holsten, A., Dominic, A.R., Costa, L., Kropp, J.P., 2013. Evaluation of the performance of meteorological forest fire indices for German federal states. Forest Ecology and Management 287, 123–131. 
} 
  @author Joaquin Bedia-Jiménez
}
\keyword{internal}
