% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tor.minus.R
\name{tor.minus}
\alias{tor.minus}
\title{Toroidal subtraction}
\usage{
tor.minus(data, mu)
}
\arguments{
\item{data}{n x d matrix of toroidal data}

\item{mu}{a d-dimensinal vector}
}
\value{
angular subtraction bewtween n x d toroidal data and
  a d dimensional vector.
}
\description{
\code{tor.minus} computes angular subtraction bewtween n x d toroidal data and
  a d dimensional vector.
}
\examples{
data <- ILE[1:200, 1:2]
Mu1 <- c(4.5, 3)
tor.minus(data, Mu1)
}
\references{
Jung, S., Park, K., & Kim, B. (2021). Clustering on the torus by conformal prediction. \emph{The Annals of Applied Statistics}, 15(4), 1583-1603.
}
\seealso{
\code{\link{ang.minus}}
}
