% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wardinit.R
\name{wardinit}
\alias{wardinit}
\title{Ward aggregation measures between singletons}
\usage{
wardinit(D, wt = NULL)
}
\arguments{
\item{D}{a object of class "dist" with the dissimilarities between the n obsevations. 
The function \code{\link{as.dist}} can be used to transform an object of class matrix to object of class "dist".}

\item{wt}{vector with the weights of the observations. By default, wt=NULL corresponds to
the case where all observations are weighted by 1/n.}
}
\value{
Returns an object of class dist with the Ward aggregation measures between the n singletons.
}
\description{
This function calculates the Ward aggregation measures between pairs of singletons.
}
\details{
The Ward agreggation measure between to singletons i and j weighted by wi and wj is : (wiwj)/(wi+wj)dij^2
where dij is the dissimilarity between i and j.
}
\references{
M. Chavent, V. Kuentz-Simonet, A. Labenne, J. Saracco. ClustGeo: an R package
for hierarchical clustering with spatial constraints.
Comput Stat (2018) 33: 1799-1822.
}
