% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoNI_functions.R
\name{CoNI}
\alias{CoNI}
\title{Correlation guided Network Integration}
\usage{
CoNI(
  edgeD,
  vertexD,
  outputDir = "./CoNIOutput/",
  saveRaw = TRUE,
  outputNameRaw = "CoNIOutput",
  onlySgRes = FALSE,
  multipleTAdj = TRUE,
  padjustvertexD = TRUE,
  correlateDFs = TRUE,
  filter_highVarianceEdge = TRUE,
  splitedgeD = TRUE,
  split_number = 2,
  delPrevious = FALSE,
  delIntermediaryFiles = TRUE,
  iteration_start = 1,
  numCores = NULL,
  verbose = TRUE,
  more_coef = FALSE,
  edgeDname = "edgeD",
  vertexDname = "vertexD",
  saveFiles = TRUE
)
}
\arguments{
\item{edgeD}{Object to use as first data input (e.g., protein expression)}

\item{vertexD}{Object to use as second data input (e.g., metabolite expression)}

\item{outputDir}{Output Directory where results are stored}

\item{saveRaw}{logical. If TRUE the raw output of CoNI is saved in the output directory (outputDir)}

\item{outputNameRaw}{Name for the raw output file if saved}

\item{onlySgRes}{logical. If TRUE CoNI output is filtered and only significant results are kept}

\item{multipleTAdj}{logical. If TRUE it will filter results after adjustment of multiple testing}

\item{padjustvertexD}{logical. If TRUE vertexD is filtered according to the significant adjusted p-value of its pairwise correlations}

\item{correlateDFs}{logical. If TRUE the elements that significantly correlate of vertexD are correlated with the elements of edgeD. Only the elements that significantly correlate are kept}

\item{filter_highVarianceEdge}{logical. If TRUE features of edgeD with high variance are filtered out}

\item{splitedgeD}{logical. If TRUE edgeD will be split in n subsets for the computation (some instances n+1). Keep as TRUE unless the data input is small}

\item{split_number}{Number of parts to split the elements of edgeD}

\item{delPrevious}{logical. If TRUE previous files of a previous run are deleted}

\item{delIntermediaryFiles}{logical. If TRUE the output file of every iteration is deleted and only a single file with all results is kept}

\item{iteration_start}{Iteration start for CoNI. Useful if run is interrupted as one can restart from the last iteration}

\item{numCores}{Cores assigned for parallelization}

\item{verbose}{logical. If TRUE output in the console is more verbose}

\item{more_coef}{logical. If TRUE it will include the partial correlation of edge and vertex Features}

\item{edgeDname}{File name extension for the edge features that significantly correlate with at least one vertex feature. This file will be read if the function is called again with the same input and with delPrevious=FALSE}

\item{vertexDname}{File name extension for the vertex features that are involved in at least one significant correlation. This file will be read if the function is called again with the same input and with delPrevious=FALSE}

\item{saveFiles}{logical. If FALSE CoNI function will not save any file to disk}
}
\value{
CoNI returns a data.frame with the correlation coefficients of the vertex-pairs, the partial correlation coefficients for every triplet, and the pvalue of the Steiger tests
}
\description{
CoNI is the main function of Correlation guided Network Integration (CoNI). Input data should come from two sources (e.g., gene expression and metabolite expression), and it should come from the same samples. It calculates all pairwise correlations of the second data input elements and the partial correlations of these pairwise elements with respect to the elements of the first data input. Both data inputs can be prefiltered to include only those elements that significantly correlate. The first data input can be prefiltered to keep just low variance elements (var<0.5). A Steiger test is used to identify significant changes between the correlation and partial correlation values. Results can be visually represented in a Network.
}
\examples{
#Run CoNI

#Load gene expression - Toy dataset of two treatments
data(GeneExpToy)
#Samples in rows and genes in columns
GeneExp <- as.data.frame(t(GeneExpToy))
hfd_gene <- GeneExp[1:8,] #high fat diet
chow_gene<- GeneExp[9:nrow(GeneExp),] #chow diet
#Load metabolite expression - Toy dataset of two treatments
data(MetaboExpToy)
MetaboExp <- MetaboExpToy
hfd_metabo <- MetaboExp[11:18,] #high fat diet
chow_metabo <- MetaboExp[1:10,] #chow diet
#Match row names both data sets
rownames(hfd_metabo)<-rownames(hfd_gene)
rownames(chow_metabo)<-rownames(chow_gene)

#Run CoNI with tiny example and no significance testing
#High fat diet
#For big datasets it is recommended to set splitedgeD to TRUE
#and split_number should be adjusted accordingly
#See vignette for an example
#Running CoNI with only a tiny dataset
\donttest{
 CoNIResultsHFD <- CoNI(hfd_gene,hfd_metabo,
                        numCores = 2,
                        onlySgRes = FALSE,
                        filter_highVarianceEdge=FALSE,
                        padjustvertexD = FALSE,
                        correlateDFs = FALSE,
                        edgeDname="HFD_genes",
                        vertexDname = "HFD_metabolites",
                        saveFiles = FALSE,
                        splitedgeD = FALSE,
                        outputDir = "./")
}

}
