% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoNI_functions.R
\name{create_stackedGlobalBarplot_perTreatment}
\alias{create_stackedGlobalBarplot_perTreatment}
\title{Stacked Global Barplot (One treatment)}
\usage{
create_stackedGlobalBarplot_perTreatment(
  CompTreatTable,
  treat = NULL,
  xlb = "Vertex-Class Pairs",
  ylb = "Number of pairs",
  max_pairsLegend = 2,
  mx.overlaps = Inf,
  szggrepel = 6,
  force = 0.1,
  szTitle = 12,
  szaxisTxt = 12,
  szaxisTitle = 12,
  ylim = NULL
)
}
\arguments{
\item{CompTreatTable}{Output of Compare_VertexClasses_sharedEdgeFeatures}

\item{treat}{Name of treatment to display. It should match the column name in the output of Compare_VertexClasses_sharedEdgeFeatures}

\item{xlb}{Name for x-axis}

\item{ylb}{Name for y-axis}

\item{max_pairsLegend}{If number of Edge Features >= max_pairsLegend, display number of Edge Features as label with ggrepel}

\item{mx.overlaps}{Max number of overlaps ggrepel}

\item{szggrepel}{Size ggrepel labels}

\item{force}{Repelling force for ggrepel labels}

\item{szTitle}{Size Title}

\item{szaxisTxt}{Size axis text}

\item{szaxisTitle}{Size axis titles}

\item{ylim}{Optional y-limits of the plot}
}
\value{
A ggplot object to create a stacked barplot. The stacked barplot shows the vertex-class pairs profile of all shared edge features but restricted to a single treatment. Every bar consists of multiple edge features (stacked) that are represented with different colors
}
\description{
This function will create a stacked barplot from the output of Compare_VertexClasses_sharedEdgeFeatures using all shared Edge Features (e.g., genes) between two treatments.
}
\examples{
data(VertexClassesSharedGenes_HFDvsChow)
create_stackedGlobalBarplot_perTreatment(CompTreatTable = VertexClassesSharedGenes_HFDvsChow,
                                         treat = "HFD",
                                         max_pairsLegend = 9,
                                         xlb = "Metabolite-class-pairs")
}
