% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advectionF.R
\name{advectionFspiralCE}
\alias{advectionFspiralCE}
\title{Spiraling advection field satisfying continuity equation}
\usage{
advectionFspiralCE(spacepoints, a, C)
}
\arguments{
\item{spacepoints}{vector of coordinates (2 x d), where d is the number of locations/grid points}

\item{a}{parameter controlling the intensity of rotational velocity (a > 0 clokwise; a < 0 conter-clockwise)}

\item{C}{parameter ranging in (0, 2*pi)}
}
\description{
Provides an advection field corresponding to a spiral motion to/from a specified reference point (sink) satisfying continuity equation (from \href{https://github.com/johannesgerer/jburkardt-m/blob/master/spiral_data/spiral_data.html}{GitHub}).
}
\examples{
library(ggquiver)
library(ggplot2)
## specify coordinates
m = 25
aux <- seq(0, m - 1, length = m)
coord <- expand.grid(aux, aux)

af <- advectionFspiralCE(spacepoints = coord,
                        a = 5,
                        C = 1)

## visualize advection field
dta <- data.frame(lon = coord[ ,1], lat = coord[ ,2], u = af[ ,1], v = af[ ,2])
ggplot(dta, aes(x = lon, y = lat, u = u, v = v)) +
geom_quiver() +
theme_light()
}
\references{
Papalexiou, S.M., Serinaldi, F., Porcu, E. (2021). Advancing
Space-Time Simulation of Random Fields: From Storms to Cyclones and Beyond.
Water Resources Research, 57, e2020WR029466, \doi{10.1029/2020WR029466}
}
