% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bry_Boschan.R
\name{TP_BryBoschan}
\alias{TP_BryBoschan}
\title{Turning points}
\usage{
TP_BryBoschan(x, frequ = 12, year = 1, month = 1)
}
\arguments{
\item{x}{univariate time series}

\item{frequ}{Frequency of the x, 12 monthly or 4 quarterly. Default value 12.}

\item{year}{The start year of the time series. Default value 1.}

\item{month}{The start month of the time series. Default value 1.}
}
\value{
The dates of the turning points
}
\description{
Calculates turning points of a time series using the Bry and Boschan (1971) methodology
}
\examples{
x <- rnorm(100)
TP_BryBoschan(x)

}
\references{
Bry, G. and Boschan, C. (1971)
 Cyclical Analysis of Time Series: Selected Procedures
 and Computer Programs,
 \emph{National Bureau of Economic Research, Inc} \bold{71}(1), 7-63.

Burns, A.F. and Mitchell, W. (1946)
 Measuring Business Cycles,
  \emph{National Bureau of Economic Research, NBER, New York.}
}
\author{
Wilmer O Martinez R
}
