% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_shiny.R
\name{age_table_gen}
\alias{age_table_gen}
\title{Generate Age Trend Summary Table}
\usage{
age_table_gen(result, q = "median", s = "F")
}
\arguments{
\item{result}{A data object containing prediction results and metadata.}

\item{q}{A string specifying the quantile of interest (e.g., \code{"quantile_50"} for the median).}

\item{s}{A string indicating the demographic group for which the summary table is generated:
\itemize{
\item \code{"F"} for female
\item \code{"M"} for male
\item \code{"F vs M"} for comparison between females and males
}}
}
\value{
A \code{datatable} object (from the \code{DT} package) containing the age trend summary table with the following columns:
\itemize{
\item \code{Age}: The age values at regular intervals (rounded to the nearest 10).
\item \code{Percentile.Volume}: The predicted volume values for the specified quantile (only for females or males).
\item \verb{PercentageChange (\%)}: The percentage change in volume between consecutive age intervals (only for females or males).
\item \code{Percentile.Volume_F}: The predicted volume values for females (when comparing genders).
\item \code{Percentile.Volume_M}: The predicted volume values for males (when comparing genders).
\item \verb{PercentageChange_F (\%)}: The percentage change for females (when comparing genders).
\item \verb{PercentageChange_M (\%)}: The percentage change for males (when comparing genders).
}
}
\description{
This function generates a summary table of age trend predictions for a specified quantile and demographic group.
The table includes the predicted volume values, percentage changes between age intervals, and other details
for either females, males, or a comparison between both genders.
}
\details{
The function processes the input data to filter predictions based on the specified quantile and demographic group.
It calculates percentage changes in predicted volume values for easier interpretation of trends. For gender comparisons
(\code{"F vs M"}), it generates side-by-side columns for females and males.

The output table is formatted using the \code{DT} package with additional features, such as CSV and Excel export options.
}
\examples{
sub_df <- age_df[,c("Volume_1", "age", "sex", "ICV_baseline")] |> na.omit()
colnames(sub_df) <- c("Volume_1", "age", "sex", "icv")
age_list <- list("Volume_1" = age_list_gen(sub_df = sub_df))
result <- age_list[[1]]
if(interactive()){
 age_table_gen(result, q = "median", s = "F")
}

}
