% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Harmonization.R
\name{combat_harm}
\alias{combat_harm}
\title{ComBatFamily Harmonization}
\usage{
combat_harm(
  eb_check = FALSE,
  result = NULL,
  features = NULL,
  batch = NULL,
  covariates = NULL,
  df = NULL,
  type = "lm",
  random = NULL,
  smooth = NULL,
  interaction = NULL,
  smooth_int_type = NULL,
  family = "comfam",
  eb = TRUE,
  ref.batch = NULL,
  predict = FALSE,
  object = NULL,
  reference = NULL,
  out_ref_include = TRUE,
  ...
)
}
\arguments{
\item{eb_check}{A boolean variable indicating whether the user wants to run the EB assumption test before harmonization.}

\item{result}{A list derived from \code{visual_prep()} that contains dataset and batch effect diagnostic information for Shiny visualization. Can be skipped if \code{features}, \code{batch}, \code{covariates} and \code{df} are provided.}

\item{features}{The name of the features to be harmonized. This can be skipped if \code{result} is provided.}

\item{batch}{The name of the batch variable. Can be skipped if \code{result} is provided.}

\item{covariates}{The names of covariates supplied to \code{model}. This can be be skipped if \code{result} is provided.}

\item{df}{Dataset to be harmonized. This can be be skipped if \code{result} is provided.}

\item{type}{The name of a regression model to be used: \code{"lmer"}, \code{"lm"}, \code{"gam"}.}

\item{random}{The variable name of a random effect in linear mixed effect model.}

\item{smooth}{The name of the covariates that require a smooth function.}

\item{interaction}{Expression of interaction terms supplied to \code{model} (eg: \code{"age,diagnosis"}).}

\item{smooth_int_type}{A vector that indicates the types of interaction in \code{gam} models. By default, \code{smooth_int_type} is set to be NULL, \code{"linear"} represents linear interaction terms.
\code{"categorical-continuous"}, \code{"factor-smooth"} both represent categorical-continuous interactions (\code{"factor-smooth"} includes categorical variable as part of the smooth),
\code{"tensor"} represents interactions with different scales, and "smooth-smooth" represents interaction between smoothed variables.}

\item{family}{The type of combat family to use, \code{comfam} or \code{covfam}.}

\item{eb}{If \code{TRUE}, uses ComBat model with empirical Bayes for mean and variance harmonization}

\item{ref.batch}{The name of the reference batch.}

\item{predict}{A boolean variable indicating whether to run ComBat from scratch or apply existing model to new dataset (currently only work for original ComBat and ComBat-GAM).}

\item{object}{Existing ComBat model.}

\item{reference}{Dataset to be considered as the reference group.}

\item{out_ref_include}{A boolean variable indicating whether the reference data should be included in the harmonized data output.}

\item{...}{Additional arguments to \code{comfam} or \code{covfam} models.}
}
\value{
If the \code{eb_check} is set to be FALSE, then \code{combat_harm} returns a list containing the following components:
\item{com_family}{ComBat family to be considered: comfam, covfam}
\item{harmonized_df}{Harmonized dataset}
\item{combat.object}{Saved ComBat model and relevant information, such as the batch variable name and whether the EB method is used}
If \code{eb_check}  is set to be TRUE, then \code{combat_harm} will return a dataframe with the EB assumption test result.
}
\description{
Conduct harmonization using four types of methods: 1) Original ComBat, 2) Longitudinal ComBat, 3) ComBat-GAM, and 4) CovBat.
}
\examples{
combat_harm(features = colnames(adni)[43:53], batch = "manufac",
covariates = c("AGE", "SEX", "DIAGNOSIS"), df = head(adni,100), type = "lm")

}
