% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deconvolution.R
\name{dcq}
\alias{dcq}
\title{DCQ - Digital Cell Quantifier}
\usage{
dcq(reference_data, mix_data, marker_set, alpha_used=0.05,
 lambda_min=0.2, number_of_repeats=3, precent_of_data=1.0)
}
\arguments{
\item{reference_data}{a data frame representing immune cell expression profiles.
Each row represents an expression of a gene, and each column represents a
different immune cell type. \code{colnames} contains the name of each immune cell
type and the \code{rownames} includes the genes' symbol. The names of each immune
cell type and the symbol of each gene should be unique. Any gene with
missing expression values must be excluded.}

\item{mix_data}{a data frame representing RNA-seq or microarray
gene-expression profiles of a given complex tissue. Each row represents an
expression of a gene, and each column represents a different experimental sample.
\code{colnames} contain the name of each sample and \code{rownames} includes the genes' symbol.
The name of each individual sample and the symbol of each gene should be unique.
Any gene with missing expression values should be excluded.}

\item{marker_set}{data frames of one column, that includes a
preselected list of genes that likely discriminate well
between the immune-cell types given in the reference data.}

\item{alpha_used, lambda_min}{parameters of the L1 and L2 regularization. It is generally
recommended to leave the default value. For more information about this
parameter, see the glmnet package.}

\item{number_of_repeats}{using one repeat will generate only one output model.
Using many repeats, DCQ calculates a collection of models, and outputs the
average and standard deviation for each predicted relative cell quantity.}

\item{precent_of_data}{in order to run the analysis over all the cell types use 1.0.
For bootstrap purposes, you can use part of the data (e.g, 0.5).}
}
\value{
a list that contains two matrices
 \item{average}{a matrix that contains the average relative quantities for each cell
   type in everytest sample.}
 \item{stdev}{a matrix that contains the standard deviations over all repeats for
   each cell types in each test sample.}
}
\description{
DCQ combines genome-wide gene expression data with an immune cell-type
 reference data to infer changes in the quantities immune cell subpopulations.
}
\examples{
data(commons)
data(dcqEx)
results <- dcq(reference_data=immgen_dat, mix_data=lung_time_series_dat, marker_set=DCQ_mar)

}
\references{
Altboum Z, Steuerman Y, David E, Barnett-Itzhaki Z, Valadarsky L, Keren-Shaul H, et al.
 Digital cell quantification identifies global immune cell dynamics during influenza
 infection. Mol Syst Biol. 2014;10: 720. doi:10.1002/msb.134947
}

